/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.editorkit;

import java.io.Serializable;
import java.net.URI;
import java.util.Properties;
import org.protege.editor.core.editorkit.EditorKitFactory;

public final class EditorKitDescriptor
implements Serializable {
    private static final long serialVersionUID = 3407968599072820006L;
    private Properties properties = new Properties();
    public static final String LABEL_KEY = "EDITOR_KIT_LABEL";
    public static final String EDITOR_KIT_FACTORY_ID = "EDITOR_KIT_FACTORY_ID";

    public EditorKitDescriptor(String label, EditorKitFactory editorKitFactory) {
        this.setEditorKitFactoryID(editorKitFactory.getId());
        this.properties.setProperty(LABEL_KEY, label);
    }

    public String getLabel() {
        return this.properties.getProperty(LABEL_KEY);
    }

    public String getEditorKitFactoryID() {
        return this.properties.getProperty(EDITOR_KIT_FACTORY_ID);
    }

    public void setEditorKitFactoryID(String id) {
        this.properties.setProperty(EDITOR_KIT_FACTORY_ID, id);
    }

    public String getString(String key) {
        return (String)this.properties.get(key);
    }

    public void setString(String key, String value) {
        this.properties.put(key, value);
    }

    public void setURI(String key, URI uri) {
        this.properties.put(key, uri);
    }

    public URI getURI(String key) {
        return (URI)this.properties.get(key);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EditorKitDescriptor) {
            return this.getLabel().equals(((EditorKitDescriptor)obj).getLabel());
        }
        return false;
    }

    public String toString() {
        return this.getLabel();
    }
}

