/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.platform.apple;

import java.io.File;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.platform.apple.AbstractAppleApplicationWrapper;
import org.protege.editor.core.ui.about.AboutPanel;
import org.protege.editor.core.ui.preferences.PreferencesDialogPanel;

public class ProtegeAppleApplication
extends AbstractAppleApplicationWrapper {
    private EditorKit eKit;
    private static ProtegeAppleApplication instance;

    public static ProtegeAppleApplication getInstance() {
        if (instance == null) {
            instance = new ProtegeAppleApplication();
        }
        return instance;
    }

    private ProtegeAppleApplication() {
    }

    public void setEditorKit(EditorKit eKit) {
        this.eKit = eKit;
        this.setEnabledPreferencesMenu(eKit != null);
    }

    protected void editFile(String fileName) throws Exception {
        ProtegeManager.getInstance().getApplication().editURI(new File(fileName).toURI());
    }

    protected boolean handlePreferencesRequest() {
        if (this.eKit != null) {
            PreferencesDialogPanel.showPreferencesDialog(null, this.eKit);
            return true;
        }
        return false;
    }

    protected boolean handleAboutRequest() {
        AboutPanel.showDialog();
        return true;
    }

    protected boolean handleQuitRequest() {
        return ProtegeApplication.handleQuit();
    }
}

