/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.plugin;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.protege.editor.core.plugin.PluginExtensionMatcher;
import org.protege.editor.core.plugin.PluginUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginExtensionFilter {
    private static Logger logger = Logger.getLogger(PluginExtensionFilter.class.getName());
    private String pluginId;
    private String extensionPointId;
    private PluginExtensionMatcher extensionMatcher;

    public PluginExtensionFilter(String pluginId, String extensionPointId, PluginExtensionMatcher extensionMatcher) {
        this.pluginId = pluginId;
        this.extensionPointId = extensionPointId;
        this.extensionMatcher = extensionMatcher;
    }

    public Set<IExtension> getExtensions() {
        HashSet<IExtension> result = new HashSet<IExtension>();
        IExtensionRegistry registry = PluginUtilities.getInstance().getExtensionRegistry();
        IExtensionPoint extpt = registry.getExtensionPoint(this.pluginId, this.extensionPointId);
        if (extpt == null) {
            logger.warning("Extension point not defined: " + this.extensionPointId + "@" + this.pluginId);
            return Collections.emptySet();
        }
        IExtension[] extensions = extpt.getExtensions();
        if (extensions == null) {
            return Collections.emptySet();
        }
        for (IExtension ext : extensions) {
            if (!this.extensionMatcher.matches(ext)) continue;
            if (ext.getUniqueIdentifier() != null) {
                result.add(ext);
                continue;
            }
            logger.warning("No ID found for " + this.extensionPointId + " in bundle: " + ext.getContributor().getName());
        }
        return result;
    }
}

