/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.plugin;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.protege.editor.core.PropertyUtil;
import org.protege.editor.core.ProtegeProperties;
import org.protege.editor.core.plugin.PluginUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginProperties {
    public static final String PLUGIN_XML_VALUE = "value";
    public static final String PROTEGE_PROPERTY_PREFIX = "@";
    public static final String EDITOR_KIT_PARAM_NAME = "editorKitId";
    public static final String CLASS_PARAM_NAME = "class";

    public static String getProtegeProperty(String key) {
        if (key.startsWith(PROTEGE_PROPERTY_PREFIX)) {
            return ProtegeProperties.getInstance().getProperty(key.substring(1, key.length()));
        }
        return null;
    }

    public static boolean isProtegeProperty(String key) {
        return key.startsWith(PROTEGE_PROPERTY_PREFIX);
    }

    public static String getParameterValue(IExtension ext, String key, String defaultValue) {
        String val = PluginUtilities.getAttribute(ext, key);
        if (val == null) {
            return defaultValue;
        }
        if (PluginProperties.isProtegeProperty(val)) {
            return PluginProperties.getProtegeProperty(val);
        }
        return val;
    }

    public static Set<String> getParameterValues(IExtension ext, String key) {
        HashSet<String> values = new HashSet<String>();
        for (IConfigurationElement config : ext.getConfigurationElements()) {
            String val;
            if (!key.equals(config.getName()) || (val = config.getAttribute(PLUGIN_XML_VALUE)) == null) continue;
            if (PluginProperties.isProtegeProperty(val)) {
                String protegeVal = PluginProperties.getProtegeProperty(val);
                if (protegeVal == null) continue;
                values.add(protegeVal);
                continue;
            }
            values.add(val);
        }
        return values;
    }

    public static boolean getBooleanParameterValue(IExtension ext, String key, boolean defaultValue) {
        return PropertyUtil.getBoolean(PluginProperties.getParameterValue(ext, key, Boolean.toString(defaultValue)), defaultValue);
    }

    public static Color getColorParameterValue(IExtension ext, String key, Color defaultColor) {
        return PropertyUtil.getColor(PluginProperties.getParameterValue(ext, key, null), defaultColor);
    }
}

