/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.core.OntologyRepository;
import org.protege.editor.core.OntologyRepositoryEntry;
import org.protege.editor.core.ui.RepositoryTable;
import org.protege.editor.core.ui.util.JOptionPaneEx;

public class OpenFromRepositoryPanel
extends JPanel {
    private static final long serialVersionUID = -328358981641882683L;
    private OntologyRepository repository;
    private RepositoryTable table;

    public OpenFromRepositoryPanel(OntologyRepository repository) {
        this.repository = repository;
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.table = new RepositoryTable(this.repository);
        this.add(new JScrollPane(this.table));
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 400);
    }

    public static OntologyRepositoryEntry showDialog(OntologyRepository repository) {
        repository.refresh();
        OpenFromRepositoryPanel panel = new OpenFromRepositoryPanel(repository);
        int ret = JOptionPaneEx.showConfirmDialog(null, "Open from " + repository.getName(), panel, -1, 2, panel.table);
        if (ret == 0) {
            return panel.table.getSelectedEntry();
        }
        return null;
    }
}

