/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.JTable;
import org.protege.editor.core.OntologyRepository;
import org.protege.editor.core.OntologyRepositoryEntry;
import org.protege.editor.core.ui.RepositoryTableModel;

public class RepositoryTable
extends JTable {
    private static final long serialVersionUID = 343836249221539974L;

    public RepositoryTable(OntologyRepository repository) {
        this.setModel(new RepositoryTableModel(repository));
        this.setRowHeight(this.getRowHeight() + 4);
        this.setShowHorizontalLines(true);
        this.setGridColor(Color.LIGHT_GRAY);
        this.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                RepositoryTable.this.sort(e);
            }
        });
    }

    private void sort(MouseEvent e) {
        int col = this.getTableHeader().columnAtPoint(e.getPoint());
        if (col == -1) {
            return;
        }
        ((RepositoryTableModel)this.getModel()).sortByColumn(col);
    }

    public URI getSelectedOntologyURI() {
        return (URI)((RepositoryTableModel)this.getModel()).getValueAt(this.getSelectedRow(), 1);
    }

    public OntologyRepositoryEntry getSelectedEntry() {
        return ((RepositoryTableModel)this.getModel()).getEntryAt(this.getSelectedRow());
    }
}

