/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.about;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.protege.editor.core.ProtegeApplication;

public class PluginInfoTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 231294024758489767L;
    private List<Bundle> bundles = ProtegeApplication.getBundleManager().getPlugins();

    public int getRowCount() {
        return this.bundles.size();
    }

    public int getColumnCount() {
        return Columns.values().length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Bundle bundle = this.bundles.get(rowIndex);
        String version_name = (String)bundle.getHeaders().get("Bundle-Version");
        Version v = null;
        if (version_name != null) {
            v = new Version(version_name);
        }
        switch (Columns.values()[columnIndex]) {
            case NAME: {
                String name = (String)bundle.getHeaders().get("Bundle-Name");
                if (name == null) {
                    name = bundle.getSymbolicName();
                }
                return name;
            }
            case VERSION: {
                return v == null ? "" : "" + v.getMajor() + "." + v.getMinor() + "." + v.getMicro();
            }
            case QUALIFIER: {
                return v.getQualifier();
            }
        }
        throw new RuntimeException("Programmer error - missed a case");
    }

    public String getColumnName(int column) {
        return Columns.values()[column].getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Columns {
        NAME("Name/ID"),
        VERSION("Version"),
        QUALIFIER("Qualifier");

        private String name;

        private Columns(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

