/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.error;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorExplainer {
    private Map<Class<? extends Throwable>, ErrorExplanationFactory> factories = new HashMap<Class<? extends Throwable>, ErrorExplanationFactory>();

    public ErrorExplainer() {
        this.addExplanationFactory(FileNotFoundException.class, new ErrorExplanationFactory<FileNotFoundException>(){

            @Override
            public <T extends FileNotFoundException> ErrorExplanation<T> createExplanation(T throwable) {
                return new ErrorExplanation<T>(throwable, "File not found: " + throwable.getMessage());
            }
        });
        this.addExplanationFactory(SAXParseException.class, new ErrorExplanationFactory<SAXParseException>(){

            @Override
            public <T extends SAXParseException> ErrorExplanation<T> createExplanation(T throwable) {
                String message = "XML error at line " + throwable.getLineNumber() + ", column " + throwable.getColumnNumber() + "\n" + throwable.getMessage();
                if (throwable.getLineNumber() <= 0 || throwable.getColumnNumber() <= 0) {
                    System.out.println("throwable = " + throwable);
                }
                return new ParseErrorExplanation<T>(throwable, message, throwable.getLineNumber() - 1, throwable.getColumnNumber() - 1);
            }
        });
    }

    public <T extends Throwable> ErrorExplanation<? extends Throwable> getErrorExplanation(T throwable, boolean traverseCauses) {
        Object cause = throwable;
        do {
            ErrorExplanationFactory<T> fac;
            if ((fac = this.getFactory(cause)) != null) {
                return fac.createExplanation(cause);
            }
            cause = cause.getCause();
        } while (traverseCauses && cause != null);
        return new ErrorExplanation<T>(throwable, throwable.getMessage());
    }

    private <T extends Throwable> ErrorExplanationFactory<T> getFactory(T throwable) {
        Class<? extends T> cls = ErrorExplainer.getBestMatchJavaClass(throwable.getClass(), this.factories.keySet());
        if (cls != null) {
            return this.factories.get(cls);
        }
        return null;
    }

    public <T extends Throwable> void addExplanationFactory(Class<T> cls, ErrorExplanationFactory<? super T> fac) {
        this.factories.put(cls, fac);
    }

    public void clearExplanationFactories() {
        this.factories.clear();
    }

    private static <T> Class<? extends T> getBestMatchJavaClass(Class<? extends T> cls, Set<Class<? extends T>> clses) {
        Class<T> mostSpecificCls = null;
        for (Class<T> candidate : clses) {
            if (!candidate.isAssignableFrom(cls) || mostSpecificCls != null && !mostSpecificCls.isAssignableFrom(candidate)) continue;
            mostSpecificCls = candidate;
        }
        return mostSpecificCls;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParseErrorExplanation<O extends Throwable>
    extends ErrorExplanation<O> {
        private int line;
        private int col;

        public ParseErrorExplanation(O cause, String message, int line, int col) {
            super(cause, message);
            this.line = line;
            this.col = col;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.col;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ErrorExplanation<O extends Throwable> {
        private O cause;
        private String message;

        public ErrorExplanation(O cause, String message) {
            this.cause = cause;
            this.message = message;
        }

        public O getCause() {
            return this.cause;
        }

        public String getMessage() {
            return this.message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ErrorExplanationFactory<O extends Throwable> {
        public <T extends O> ErrorExplanation<T> createExplanation(T var1);
    }
}

