/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.error;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.error.ErrorLogListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorLog
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = Logger.getLogger(ErrorLog.class);
    private static int errorCount;
    public static final int MAX_NUMBER_OF_ERRORS = 100;
    private List<ErrorLogEntry> errors = new ArrayList<ErrorLogEntry>();
    private List<WeakReference<ErrorLogListener>> listeners = new ArrayList<WeakReference<ErrorLogListener>>();

    public void addListener(ErrorLogListener listener) {
        this.listeners.add(new WeakReference<ErrorLogListener>(listener));
    }

    public void removeListener(ErrorLogListener listener) {
        this.listeners.remove(new WeakReference<ErrorLogListener>(listener));
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.logError(e);
    }

    public void logError(Throwable throwable) {
        logger.warn((Object)"Error logged", throwable);
        ++errorCount;
        this.errors.add(new ErrorLogEntry(throwable));
        if (this.errors.size() > 100) {
            this.errors.remove(0);
        }
        this.fireErrorLoggedEvent();
    }

    public List<ErrorLogEntry> getEntries() {
        return Collections.unmodifiableList(this.errors);
    }

    public void clear() {
        this.errors.clear();
        this.fireErrorLogClearedEvent();
    }

    private void fireErrorLoggedEvent() {
        for (WeakReference<ErrorLogListener> ref : new ArrayList<WeakReference<ErrorLogListener>>(this.listeners)) {
            ErrorLogListener listener = (ErrorLogListener)ref.get();
            if (listener != null) {
                listener.errorLogged(this);
                continue;
            }
            this.listeners.remove(ref);
        }
    }

    private void fireErrorLogClearedEvent() {
        for (WeakReference<ErrorLogListener> ref : new ArrayList<WeakReference<ErrorLogListener>>(this.listeners)) {
            ErrorLogListener listener = (ErrorLogListener)ref.get();
            if (listener != null) {
                listener.errorLogCleared(this);
                continue;
            }
            this.listeners.remove(ref);
        }
    }

    public void handleError(Thread t, Throwable e) {
        this.logError(e);
    }

    public class ErrorLogEntry {
        private int id;
        private long timeStamp = System.currentTimeMillis();
        private Throwable throwable;

        public ErrorLogEntry(Throwable throwable) {
            this.throwable = throwable;
            this.id = errorCount;
        }

        public int getId() {
            return this.id;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Error ");
            sb.append(this.id);
            sb.append(" Logged at ");
            sb.append(new Date(this.timeStamp));
            sb.append("\n");
            sb.append(this.throwable.getClass().getSimpleName());
            sb.append(": ");
            sb.append(this.throwable.getMessage());
            sb.append("\n");
            for (StackTraceElement element : this.throwable.getStackTrace()) {
                sb.append("    ");
                sb.append(element.toString());
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

