/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.error;

import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.protege.editor.core.ui.error.ErrorLog;
import org.protege.editor.core.ui.error.ErrorLogListener;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.core.ui.error.SendErrorReportHandler;
import org.protege.editor.core.ui.util.Icons;

public class ErrorNotificationLabel
extends JLabel {
    private static final long serialVersionUID = -1816375999125772505L;
    private ErrorLogPanel panel;
    private ErrorLogListener listener;

    public ErrorNotificationLabel(ErrorLog errorLog, SendErrorReportHandler handler) {
        super(Icons.getIcon("error.png"));
        this.setToolTipText("Protege-Guard: Click to view errors");
        this.setupMouseHandler();
        this.listener = new ErrorLogListener(){

            public void errorLogged(ErrorLog errorLog) {
                ErrorNotificationLabel.this.setVisible(true);
            }

            public void errorLogCleared(ErrorLog errorLog) {
                ErrorNotificationLabel.this.setVisible(false);
            }
        };
        errorLog.addListener(this.listener);
        this.setVisible(false);
        this.panel = new ErrorLogPanel(errorLog, handler);
    }

    private void setupMouseHandler() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ErrorNotificationLabel.this.showErrors();
            }
        });
    }

    private void showErrors() {
        this.panel.fillLog();
        JOptionPane optionPane = new JOptionPane(this.panel, -1, -1);
        JDialog dlg = optionPane.createDialog(SwingUtilities.getAncestorOfClass(Frame.class, this), "Errors");
        dlg.setResizable(true);
        dlg.setVisible(true);
    }
}

