/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.preferences.PreferencesPanel;
import org.protege.editor.core.ui.preferences.PreferencesPanelPlugin;
import org.protege.editor.core.ui.preferences.PreferencesPanelPluginLoader;

public class PreferencesDialogPanel
extends JPanel
implements Disposable {
    private static final long serialVersionUID = 6338996558666619642L;
    private Map<String, PreferencesPanel> map = new HashMap<String, PreferencesPanel>();
    private Map<String, JComponent> scrollerMap = new HashMap<String, JComponent>();
    private JTabbedPane tabbedPane;
    private static final String PREFS_HISTORY_PANEL_KEY = "prefs.history.panel";

    public PreferencesDialogPanel(EditorKit editorKit) {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        PreferencesPanelPluginLoader loader = new PreferencesPanelPluginLoader(editorKit);
        TreeSet<PreferencesPanelPlugin> plugins = new TreeSet<PreferencesPanelPlugin>(new Comparator<PreferencesPanelPlugin>(){

            @Override
            public int compare(PreferencesPanelPlugin o1, PreferencesPanelPlugin o2) {
                String s1 = o1.getLabel();
                String s2 = o2.getLabel();
                return s1.compareTo(s2);
            }
        });
        plugins.addAll(loader.getPlugins());
        for (PreferencesPanelPlugin plugin : plugins) {
            try {
                PreferencesPanel panel = (PreferencesPanel)plugin.newInstance();
                panel.initialise();
                String label = plugin.getLabel();
                JScrollPane scroller = new JScrollPane(panel);
                scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.map.put(label, panel);
                this.scrollerMap.put(label, scroller);
                this.tabbedPane.addTab(label, scroller);
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
        this.add(this.tabbedPane);
    }

    public void dispose() {
        for (PreferencesPanel panel : new ArrayList<PreferencesPanel>(this.map.values())) {
            try {
                panel.dispose();
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
        this.map.clear();
    }

    public void applyPreferences() {
        for (PreferencesPanel panel : new ArrayList<PreferencesPanel>(this.map.values())) {
            try {
                panel.applyChanges();
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
    }

    protected String getSelectedPanel() {
        Component c = this.tabbedPane.getSelectedComponent();
        if (c instanceof JScrollPane) {
            c = ((JScrollPane)c).getViewport().getView();
        }
        for (String tabName : this.map.keySet()) {
            if (!c.equals(this.map.get(tabName))) continue;
            return tabName;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return new Dimension(850, 725);
    }

    public static void showPreferencesDialog(String selectedPanel, EditorKit editorKit) {
        int ret;
        Component c;
        PreferencesDialogPanel panel = new PreferencesDialogPanel(editorKit);
        Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences(PreferencesDialogPanel.class);
        if (selectedPanel == null) {
            selectedPanel = prefs.getString(PREFS_HISTORY_PANEL_KEY, null);
        }
        if ((c = (Component)panel.scrollerMap.get(selectedPanel)) != null) {
            panel.tabbedPane.setSelectedComponent(c);
        }
        JOptionPane op = new JOptionPane(panel, -1, 2);
        JDialog dlg = op.createDialog(editorKit.getWorkspace(), "Preferences");
        dlg.setResizable(true);
        dlg.setVisible(true);
        Object o = op.getValue();
        if (o != null && (ret = ((Integer)o).intValue()) == 0) {
            panel.applyPreferences();
        }
        prefs.putString(PREFS_HISTORY_PANEL_KEY, panel.getSelectedPanel());
        panel.dispose();
    }
}

