/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.protege.editor.core.ui.preferences.PreferencesPanel;

public class PreferencesPanelLayoutManager
implements LayoutManager2 {
    public static final int GUTTER_WIDTH = 10;
    public static final int ROW_MARGIN = 10;
    private List<Component> compList = new ArrayList<Component>();
    private Map<Component, JLabel> labelMap = new HashMap<Component, JLabel>();
    private JComponent baseComponent;

    public PreferencesPanelLayoutManager(JComponent component) {
        this.baseComponent = component;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (this.labelMap.values().contains(comp)) {
            return;
        }
        this.compList.add(comp);
        if (constraints != null) {
            JLabel label = new JLabel((String)constraints);
            this.labelMap.put(comp, label);
            this.baseComponent.add(label);
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public void invalidateLayout(Container target) {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
        this.labelMap.remove(comp);
        this.compList.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int prefWidth = insets.left + insets.right + 10;
        int prefHeight = insets.top + insets.bottom;
        int maxLabelWidth = 0;
        for (JLabel label : this.labelMap.values()) {
            int labelPrefWidth = label.getPreferredSize().width;
            if (labelPrefWidth <= maxLabelWidth) continue;
            maxLabelWidth = labelPrefWidth;
        }
        prefWidth += maxLabelWidth;
        int maxComponentPrefWidth = 0;
        Iterator<Component> it = this.compList.iterator();
        while (it.hasNext()) {
            Component c = it.next();
            Dimension prefCompSize = c.getPreferredSize();
            if (prefCompSize.width > maxComponentPrefWidth) {
                maxComponentPrefWidth = prefCompSize.width;
            }
            prefHeight += prefCompSize.height;
            if (!it.hasNext()) continue;
            prefHeight += 10;
        }
        return new Dimension(prefWidth += maxComponentPrefWidth, prefHeight);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    public void layoutContainer(Container parent) {
        int maxWidth = 0;
        for (JLabel label : this.labelMap.values()) {
            int labelPrefWidth = label.getPreferredSize().width;
            if (labelPrefWidth <= maxWidth) continue;
            maxWidth = labelPrefWidth;
        }
        Insets insets = parent.getInsets();
        int curY = 0;
        int curX = 0;
        int maxY = parent.getHeight();
        int maxCompWidth = parent.getWidth() - maxWidth - insets.left - insets.right - 10;
        curY = insets.top;
        curX = insets.left;
        maxY -= insets.bottom;
        for (Component c : this.compList) {
            if (!(c instanceof PreferencesPanel)) {
                JLabel label = this.labelMap.get(c);
                if (label != null) {
                    Dimension labelPrefSize = label.getPreferredSize();
                    label.setSize(labelPrefSize);
                    label.setLocation(curX + maxWidth - labelPrefSize.width, curY + 2);
                }
                Dimension prefCompSize = c.getPreferredSize();
                c.setSize(prefCompSize.width < maxCompWidth ? prefCompSize.width : maxCompWidth, prefCompSize.height);
                c.setLocation(curX + maxWidth + 10, curY);
                curY = curY + prefCompSize.height + 10;
                continue;
            }
            c.setLocation(curX, curY);
            Dimension prefSize = c.getPreferredSize();
            c.setSize(parent.getWidth(), prefSize.height);
            curY = curY + prefSize.height + 10;
        }
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel();
        panel.setLayout(new PreferencesPanelLayoutManager(panel));
        panel.add((Component)new JTextField(30), "Base URI");
        panel.add(new JCheckBox("Include year"));
        panel.add(new JCheckBox("Include month"));
        panel.add(new JCheckBox("Include day"));
        panel.add(new JPanel(){
            private static final long serialVersionUID = 458183481480038217L;

            public Dimension getPreferredSize() {
                return new Dimension(20, 20);
            }
        });
        panel.add(new JSeparator(){
            private static final long serialVersionUID = 147186206224716146L;

            public Dimension getPreferredSize() {
                return new Dimension(100, 5);
            }
        });
        panel.setBorder(BorderFactory.createMatteBorder(30, 30, 30, 30, Color.MAGENTA));
        JList<Object> list = new JList<Object>(new Object[]{"A", "B", "C"});
        list.setPreferredSize(new Dimension(300, 200));
        panel.add(list, "Choose a value for me");
        JFrame f = new JFrame();
        f.setContentPane(panel);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

