/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.protege.editor.core.ui.progress.BackgroundTask;
import org.protege.editor.core.ui.progress.BackgroundTaskManager;

public class BackgroundTaskListPanel
extends JPanel {
    private static final long serialVersionUID = -3923645519834624950L;
    private JTextArea textArea;
    private BackgroundTaskManager mngr;

    public BackgroundTaskListPanel(BackgroundTaskManager mngr) {
        this.mngr = mngr;
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("monospaced", 0, 12));
        JPanel contentPane = new JPanel(new BorderLayout(7, 7));
        contentPane.add(new JScrollPane(this.textArea));
        this.add((Component)contentPane, "Center");
        this.fillLog();
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    public void setVisible(boolean b) {
        this.fillLog();
        Container parent = this.getParent();
        if (parent != null) {
            int w = (parent.getWidth() - this.getWidth()) / 2;
            int h = (parent.getHeight() - this.getHeight()) / 2;
            this.setLocation(w, h);
        }
        super.setVisible(b);
    }

    public void fillLog() {
        this.textArea.setText("");
        int indent = 0;
        for (BackgroundTask entry : this.mngr.getRunningTasks()) {
            for (int i = 0; i < indent; ++i) {
                this.textArea.append("\t");
            }
            this.textArea.append(entry.toString());
            this.textArea.append("\n");
            ++indent;
        }
    }

    public static void showTaskDialog(BackgroundTaskManager mngr) {
        BackgroundTaskListPanel panel = new BackgroundTaskListPanel(mngr);
        JOptionPane optionPane = new JOptionPane(panel, -1, -1);
        JDialog dlg = optionPane.createDialog(null, "Background Tasks");
        dlg.setResizable(true);
        dlg.setVisible(true);
    }
}

