/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckList
extends JComponent {
    private static final long serialVersionUID = -358732140734918547L;
    private JList list;
    private Map<Object, JCheckBox> item2CheckBoxMap;
    private List<CheckListListener> listeners;
    private ListDataListener lsnr = new ListDataListener(){

        public void intervalAdded(ListDataEvent e) {
            CheckList.this.updateCheckBoxes();
        }

        public void intervalRemoved(ListDataEvent e) {
            CheckList.this.updateCheckBoxes();
        }

        public void contentsChanged(ListDataEvent e) {
        }
    };

    public CheckList(JList list) {
        this.list = list;
        this.listeners = new ArrayList<CheckListListener>();
        this.item2CheckBoxMap = new IdentityHashMap<Object, JCheckBox>();
        this.setLayout(new CheckListLayoutManager());
        list.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("model")) {
                    CheckList.this.handleModelChange();
                    ((ListModel)evt.getOldValue()).removeListDataListener(CheckList.this.lsnr);
                }
            }
        });
        list.getModel().addListDataListener(this.lsnr);
        this.add(list);
        this.updateCheckBoxes();
    }

    public Collection<Object> getCheckedItems() {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object item : this.item2CheckBoxMap.keySet()) {
            if (!this.item2CheckBoxMap.get(item).isSelected()) continue;
            items.add(item);
        }
        return items;
    }

    public void addCheckListListener(CheckListListener listener) {
        this.listeners.add(listener);
    }

    public void removeCheckListListener(CheckListListener listener) {
        this.listeners.remove(listener);
    }

    public void handleModelChange() {
        this.updateCheckBoxes();
        this.list.getModel().addListDataListener(this.lsnr);
    }

    private void updateCheckBoxes() {
        JCheckBox cb;
        IdentityHashMap<Object, JCheckBox> remaining = new IdentityHashMap<Object, JCheckBox>();
        remaining.putAll(this.item2CheckBoxMap);
        ListModel model = this.list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            final Object item = model.getElementAt(i);
            if (this.item2CheckBoxMap.get(item) == null) {
                cb = new JCheckBox();
                cb.setSelected(true);
                cb.setOpaque(false);
                this.item2CheckBoxMap.put(item, cb);
                this.add(cb);
                final int index = i;
                cb.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CheckList.this.fireCheckChanged(item, index, cb.isSelected());
                    }
                });
            }
            remaining.remove(item);
        }
        for (final Object item : remaining.keySet()) {
            cb = (JCheckBox)remaining.get(item);
            this.remove(cb);
            this.item2CheckBoxMap.remove(item);
        }
        this.repaint();
    }

    protected void fireCheckChanged(Object item, int index, boolean b) {
        for (CheckListListener lsnr : new ArrayList<CheckListListener>(this.listeners)) {
            if (b) {
                lsnr.itemChecked(item);
                continue;
            }
            lsnr.itemUnchecked(item);
        }
    }

    public static void main(String[] args) {
        DefaultListModel<String> m = new DefaultListModel<String>();
        for (int i = 0; i < 5000; ++i) {
            m.addElement("X" + i);
        }
        CheckList list = new CheckList(new JList(m));
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add(new JScrollPane(list));
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }

    public static interface CheckListListener {
        public void itemChecked(Object var1);

        public void itemUnchecked(Object var1);
    }

    private class CheckListLayoutManager
    implements LayoutManager {
        private JCheckBox cb = new JCheckBox();

        private CheckListLayoutManager() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension listPrefSize = CheckList.this.list.getPreferredSize();
            return new Dimension(listPrefSize.width + 20, listPrefSize.height);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension();
        }

        public void layoutContainer(Container parent) {
            this.cb.setSize(this.cb.getPreferredSize());
            this.cb.setLocation(2, 2);
            parent.getInsets();
            CheckList.this.list.setBounds(20, 0, parent.getWidth() - 20, parent.getHeight());
            ListModel listModel = CheckList.this.list.getModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                JCheckBox cb = (JCheckBox)CheckList.this.item2CheckBoxMap.get(listModel.getElementAt(i));
                if (cb == null) continue;
                Rectangle bounds = CheckList.this.list.getCellBounds(i, i);
                cb.setBounds(0, bounds.y, bounds.height + 20, bounds.height);
            }
        }
    }
}

