/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.UIUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileURIPanel
extends JPanel {
    private static final long serialVersionUID = -9037381161423211140L;
    private Action browseAction = new AbstractAction("Browse..."){
        private static final long serialVersionUID = 7684199291744099622L;

        public void actionPerformed(ActionEvent e) {
            FileURIPanel.this.handleBrowse();
        }
    };
    private JTextField textField;
    private ArrayList<ChangeListener> listeners;
    private Set<String> fileExtensions;

    public FileURIPanel(Set<String> fileExtensions) {
        this.fileExtensions = fileExtensions;
        this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.setLayout(new BorderLayout(7, 7));
        JPanel holder = new JPanel(new BorderLayout(7, 7));
        this.textField = new JTextField(30);
        holder.add((Component)this.textField, "North");
        holder.add((Component)new JButton(this.browseAction), "East");
        this.add((Component)holder, "North");
        this.listeners = new ArrayList();
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                FileURIPanel.this.fireStateChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                FileURIPanel.this.fireStateChanged();
            }
        });
    }

    private void handleBrowse() {
        File f;
        JFrame parent = null;
        if (parent == null) {
            parent = new JFrame();
        }
        if ((f = UIUtil.openFile(parent, "Select an ontology file", "OWL File", this.fileExtensions)) != null) {
            this.textField.setText(f.getAbsolutePath());
        }
    }

    public void setURI(URI uri) {
        this.textField.setText(uri.toString());
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireStateChanged() {
        for (ChangeListener listener : new ArrayList<ChangeListener>(this.listeners)) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    public URI getURI() throws URISyntaxException {
        return new URI(this.textField.getText());
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setContentPane(new FileURIPanel(new HashSet<String>(Arrays.asList("owl"))));
        f.setVisible(true);
        f.pack();
    }
}

