/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.protege.editor.core.PropertyUtil;
import org.protege.editor.core.ProtegeProperties;

public class LinkLabel
extends JLabel {
    private static final long serialVersionUID = -4294549567545547816L;
    private Color linkColor;
    private Color hoverColor;
    private Cursor oldCursor;
    private ActionListener linkListener;

    public LinkLabel(String text, ActionListener linkListener) {
        super(text);
        this.linkListener = linkListener;
        this.linkColor = PropertyUtil.getColor(ProtegeProperties.getInstance().getProperty("org.protege.propertycolor"), Color.GRAY);
        this.hoverColor = PropertyUtil.getColor(ProtegeProperties.getInstance().getProperty("org.protege.classcolor"), Color.GRAY);
        this.setForeground(this.linkColor);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                LinkLabel.this.setHoverMode(true);
            }

            public void mouseExited(MouseEvent e) {
                LinkLabel.this.setHoverMode(false);
            }

            public void mouseReleased(MouseEvent e) {
                LinkLabel.this.activateLink();
            }
        });
        this.setFont(this.getFont().deriveFont(1, 12.0f));
    }

    public void setLinkColor(Color color) {
        this.linkColor = color;
    }

    public void setHoverColor(Color color) {
        this.hoverColor = color;
    }

    private void setHoverMode(boolean b) {
        if (b && this.isEnabled()) {
            this.setForeground(this.hoverColor);
            this.oldCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setForeground(this.linkColor);
            if (this.oldCursor != null) {
                this.setCursor(this.oldCursor);
            }
        }
    }

    private void activateLink() {
        if (this.isEnabled()) {
            this.linkListener.actionPerformed(new ActionEvent(this, 0, this.getText()));
        }
    }

    public static void main(String[] args) {
        Box box = new Box(1);
        box.add(new LinkLabel("Test link!", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        }));
        box.add(Box.createVerticalStrut(30));
        box.add(new LinkLabel("Another link", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        }));
        JFrame f = new JFrame();
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        panel.add(box);
        f.setDefaultCloseOperation(3);
        f.setContentPane(panel);
        f.pack();
        f.setVisible(true);
    }
}

