/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.protege.editor.core.platform.OSUtils;
import org.protege.editor.core.platform.apple.MacUIUtil;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.util.OpenRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUtil {
    public static final String FILE_PREFERENCES_KEY = "FILE_PREFERENCES_KEY";
    public static final String CURRENT_FILE_DIRECTORY_KEY = "CURRENT_FILE_DIRECTORY_KEY";
    public static final String ENABLE_TEMP_DIRECTORIES_KEY = "ENABLE_TEMP_DIRECTORIES_KEY";

    public static String getCurrentFileDirectory() {
        String dir = "~";
        Preferences p = PreferencesManager.getInstance().getApplicationPreferences(FILE_PREFERENCES_KEY);
        dir = p.getString(CURRENT_FILE_DIRECTORY_KEY, dir);
        return dir;
    }

    public static void setCurrentFileDirectory(String dir) {
        Preferences p = PreferencesManager.getInstance().getApplicationPreferences(FILE_PREFERENCES_KEY);
        p.putString(CURRENT_FILE_DIRECTORY_KEY, dir);
    }

    @Deprecated
    public static File openFile(Component parent, String title, Set<String> extensions) {
        return UIUtil.openFile(parent, title, null, extensions);
    }

    public static File openFile(Component parent, String title, final String description, final Set<String> extensions) {
        File f;
        if (OSUtils.isOSX() && parent instanceof Window) {
            return MacUIUtil.openFile((Window)parent, title, extensions);
        }
        JFileChooser fileDialog = new JFileChooser(UIUtil.getCurrentFileDirectory());
        if (extensions != null && !extensions.isEmpty()) {
            fileDialog.setFileFilter(new FileFilter(){

                public String getDescription() {
                    return description;
                }

                public boolean accept(File f) {
                    if (extensions.isEmpty() || f.isDirectory()) {
                        return true;
                    }
                    String name = f.getName();
                    for (String ext : extensions) {
                        if (!name.toLowerCase().endsWith(ext.toLowerCase())) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        fileDialog.setDialogType(0);
        int retVal = fileDialog.showOpenDialog(parent);
        if (retVal == 0 && (f = fileDialog.getSelectedFile()) != null) {
            if (f.getParent() != null) {
                UIUtil.setCurrentFileDirectory(f.getParent());
            }
            return f;
        }
        return null;
    }

    @Deprecated
    public static File saveFile(Component parent, String title, Set<String> extensions, String initialName) {
        return UIUtil.saveFile(parent, title, null, extensions, initialName);
    }

    public static File saveFile(Component parent, String title, final String description, final Set<String> extensions, String initialName) {
        if (OSUtils.isOSX() && parent instanceof Window) {
            return MacUIUtil.saveFile((Window)parent, title, extensions, initialName);
        }
        JFileChooser fileDialog = new JFileChooser(UIUtil.getCurrentFileDirectory());
        if (extensions != null && !extensions.isEmpty()) {
            fileDialog.setFileFilter(new FileFilter(){

                public String getDescription() {
                    return description;
                }

                public boolean accept(File f) {
                    if (extensions.isEmpty() || f.isDirectory()) {
                        return true;
                    }
                    String name = f.getName();
                    for (String ext : extensions) {
                        if (!name.toLowerCase().endsWith(ext.toLowerCase())) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        fileDialog.setDialogType(1);
        if (initialName != null) {
            fileDialog.setSelectedFile(new File(initialName));
        }
        int retVal = fileDialog.showSaveDialog(parent);
        File f = null;
        if (retVal == 0 && (f = fileDialog.getSelectedFile()) != null) {
            if (f.getParent() != null) {
                UIUtil.setCurrentFileDirectory(f.getParent());
            }
            return f;
        }
        return null;
    }

    @Deprecated
    public static File saveFile(Window parent, String title, Set<String> extensions) {
        return UIUtil.saveFile(parent, title, null, extensions, null);
    }

    public static File saveFile(Window parent, String title, String description, Set<String> extensions) {
        return UIUtil.saveFile(parent, title, description, extensions, null);
    }

    public static File chooseFolder(Component parent, String title) {
        if (System.getProperty("os.name").indexOf("OS X") != -1) {
            return MacUIUtil.chooseOSXFolder(parent, title);
        }
        JFileChooser chooser = new JFileChooser();
        File currentDirectory = new File(UIUtil.getCurrentFileDirectory());
        if (currentDirectory != null) {
            chooser.setSelectedFile(currentDirectory);
        }
        chooser.setDialogTitle(title);
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(parent) == 0) {
            File selectedDirectory = chooser.getSelectedFile();
            if (selectedDirectory != null) {
                UIUtil.setCurrentFileDirectory(selectedDirectory.toString());
            }
            return selectedDirectory;
        }
        return null;
    }

    public static void openRequest(OpenRequestHandler handler) throws Exception {
        int ret = JOptionPane.showConfirmDialog(handler.getCurrentWorkspace(), "Do you want to open the ontology in the current window?", "Open in current window", 1, 3);
        if (ret == 0) {
            handler.openInCurrentWorkspace();
        } else if (ret == 1) {
            handler.openInNewWorkspace();
        }
    }

    public static <T> Collection<T> getComponentsExtending(Component component, Class<? extends T> clazz) {
        ArrayList components = new ArrayList();
        UIUtil.addComponentsExtending(component, clazz, components);
        return components;
    }

    private static <T> void addComponentsExtending(Component component, Class<? extends T> clazz, Collection<T> components) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int nSubcomponents = container.getComponentCount();
            for (int i = 0; i < nSubcomponents; ++i) {
                Component subComponent = container.getComponent(i);
                if (clazz.isAssignableFrom(subComponent.getClass())) {
                    components.add(clazz.cast(subComponent));
                    continue;
                }
                UIUtil.addComponentsExtending(subComponent, clazz, components);
            }
        }
    }
}

