/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.ComponentFactory;

public class URLPanel
extends JPanel {
    private static final long serialVersionUID = -7020642060171962002L;
    private JTextField textField = ComponentFactory.createTextField();
    private ArrayList<ChangeListener> listeners = new ArrayList();

    public URLPanel() {
        this.setLayout(new BorderLayout(7, 7));
        this.add((Component)this.textField, "North");
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                URLPanel.this.fireChange();
            }

            public void removeUpdate(DocumentEvent e) {
                URLPanel.this.fireChange();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    public URL getURL() {
        try {
            URI uri = new URI(this.textField.getText());
            return uri.toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChange() {
        for (ChangeListener listener : new ArrayList<ChangeListener>(this.listeners)) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }
}

