/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyingOptionPane
extends JOptionPane {
    private static final long serialVersionUID = -6308201481924625979L;
    private static final Logger logger = Logger.getLogger(VerifyingOptionPane.class);
    private JButton okButton;

    public VerifyingOptionPane(JComponent c) {
        super(c, -1, 2);
    }

    public VerifyingOptionPane(JComponent c, int messageType, int optionType) {
        super(c, messageType, optionType);
    }

    public void setOKEnabled(boolean enabled) {
        if (this.okButton == null) {
            this.okButton = this.getButtonComponent(this, JButton.class, (String)UIManager.get("OptionPane.okButtonText"));
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(enabled);
        } else {
            logger.warn((Object)"Cannot find OK button for this system. Please report this with details of your OS and language.");
        }
    }

    private <T extends JComponent> T getButtonComponent(JComponent parent, Class<T> type, String name) {
        if (type.isAssignableFrom(parent.getClass()) && parent instanceof JButton && name.equals(((JButton)parent).getText())) {
            return (T)parent;
        }
        for (Component c : parent.getComponents()) {
            T target;
            if (!(c instanceof JComponent) || (target = this.getButtonComponent((JComponent)c, type, name)) == null) continue;
            return target;
        }
        return null;
    }
}

