/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.protege.editor.core.ui.view.button.ViewButtonUI;

public class ViewBanner
extends JPanel {
    private static final long serialVersionUID = 2607019846677273073L;
    private JPanel toolBarPanel;
    private JPanel labelPanel;
    private JLabel label;
    private JToolBar toolBar;
    private Color backgroundColor;
    private Color foregroundColor;
    private String labelText;
    private Color defaultBackgroundColor;

    public ViewBanner(String labelText, Color bannerColor) {
        this.defaultBackgroundColor = bannerColor;
        this.backgroundColor = bannerColor;
        this.foregroundColor = Color.WHITE;
        this.labelText = labelText;
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(this.backgroundColor);
        this.labelPanel = new JPanel(new BorderLayout());
        this.add((Component)this.labelPanel, "North");
        this.labelPanel.setBackground(null);
        this.labelPanel.setOpaque(true);
        this.label = new JLabel();
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.label.setForeground(this.foregroundColor);
        this.setText("");
        this.toolBar = new JToolBar();
        this.toolBar.setBorderPainted(false);
        this.toolBar.setFloatable(false);
        this.toolBar.setOpaque(false);
        this.toolBarPanel = new JPanel(new BorderLayout());
        this.toolBarPanel.add((Component)this.toolBar, "East");
        this.toolBarPanel.setOpaque(true);
        this.toolBarPanel.setBackground(this.backgroundColor);
        this.labelPanel.add((Component)this.toolBarPanel, "East");
        this.labelPanel.add((Component)this.label, "West");
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("focusOwner")) {
                    ViewBanner.this.repaint();
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public void setText(String text) {
        this.label.setForeground(this.foregroundColor);
        this.label.setText(this.labelText + ": " + text);
    }

    public void setBannerColor(Color color) {
        this.backgroundColor = color;
        this.labelPanel.setBackground(this.backgroundColor);
        this.toolBarPanel.setBackground(this.backgroundColor);
        this.revalidate();
    }

    public void setPinned(boolean b) {
        if (b) {
            this.setBannerColor(Color.GRAY);
        } else {
            this.setBannerColor(this.defaultBackgroundColor);
        }
    }

    public void removeAllActions() {
        this.toolBar.removeAll();
    }

    public void addAction(Action action) {
        String name = (String)action.getValue("Name");
        action.putValue("Name", "");
        action.putValue("ShortDescription", name);
        JButton button = new JButton(action){
            private static final long serialVersionUID = -5577350824168578334L;

            public void updateUI() {
            }
        };
        button.setFocusable(false);
        this.toolBar.add(button);
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon != null) {
            button.setPreferredSize(new Dimension(icon.getIconWidth() + 2, icon.getIconHeight()));
            button.setOpaque(false);
            button.setUI(new ViewButtonUI());
            button.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }
}

