/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.coode.mdock.ComponentFactory;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.view.ViewComponentPluginAdapter;
import org.protege.editor.core.ui.view.ViewComponentPluginLoader;
import org.protege.editor.core.ui.workspace.Workspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewComponentFactory
implements ComponentFactory {
    private Workspace workspace;
    private ViewComponentPlugin emptyPlugin;

    public ViewComponentFactory(Workspace workspace) {
        this.workspace = workspace;
    }

    public JComponent createComponent(Map<String, String> properties) {
        String pluginId = properties.get("pluginId");
        ViewComponentPluginLoader loader = new ViewComponentPluginLoader(this.workspace);
        for (ViewComponentPlugin plugin : loader.getPlugins()) {
            if (!plugin.getId().equals(pluginId)) continue;
            return new View(plugin, this.workspace);
        }
        return new View(this.getEmptyPlugin(pluginId, "Couldn't load view plugin: " + pluginId), this.workspace);
    }

    public ViewComponentPlugin getEmptyPlugin(final String pluginId, final String message) {
        if (this.emptyPlugin == null) {
            this.emptyPlugin = new ViewComponentPluginAdapter(){

                public String getLabel() {
                    return pluginId;
                }

                public Workspace getWorkspace() {
                    return ViewComponentFactory.this.workspace;
                }

                public ViewComponent newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                    return new ViewComponent(){
                        private static final long serialVersionUID = -4964511834485031332L;

                        public void initialise() throws Exception {
                            this.setLayout(new BorderLayout());
                            this.add((Component)new JLabel(message), "Center");
                        }

                        public void dispose() throws Exception {
                        }
                    };
                }
            };
        }
        return this.emptyPlugin;
    }
}

