/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ui.tabbedpane.ViewTabbedPane;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewContainer;

public class ViewHolder
extends JComponent
implements Disposable {
    public static final Logger LOGGER = Logger.getLogger(ViewHolder.class);
    private static final long serialVersionUID = 5192903791732587041L;
    private JSplitPane splitPane;
    private String loc;
    private JTabbedPane tabbedHolder;

    public ViewHolder(String id, String loc, JSplitPane sp) {
        this.loc = loc;
        this.splitPane = sp;
        this.setLayout(new BorderLayout());
        this.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                if (ViewHolder.this.getComponentCount() == 1) {
                    ViewHolder.this.splitPane.add((Component)ViewHolder.this, ViewHolder.this.loc);
                }
            }

            public void componentRemoved(ContainerEvent e) {
                if (ViewHolder.this.getComponentCount() == 0) {
                    ViewHolder.this.splitPane.remove(ViewHolder.this);
                }
            }
        });
        this.createHolder();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    }

    private void createHolder() {
        this.tabbedHolder = new ViewTabbedPane();
        this.tabbedHolder.setTabPlacement(3);
        this.tabbedHolder.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                if (ViewHolder.this.tabbedHolder.getComponentCount() == 1) {
                    ViewHolder.this.add(ViewHolder.this.tabbedHolder);
                }
            }

            public void componentRemoved(ContainerEvent e) {
                if (ViewHolder.this.tabbedHolder.getComponentCount() == 0) {
                    ViewHolder.this.remove(ViewHolder.this.tabbedHolder);
                }
            }
        });
    }

    public void addView(View view) {
        ViewContainer viewContainer = new ViewContainer(view);
        this.tabbedHolder.addTab(view.getViewName(), viewContainer);
        this.tabbedHolder.setSelectedComponent(viewContainer);
    }

    public View getView(String id) {
        return this.getView(id, this);
    }

    private View getView(String id, Component c) {
        Collection<View> views = UIUtil.getComponentsExtending(c, View.class);
        for (View view : views) {
            if (!view.getId().equals(id)) continue;
            return view;
        }
        return null;
    }

    public boolean containsView(String id) {
        return this.getView(id) != null;
    }

    public void dispose() {
        for (ViewContainer container : UIUtil.getComponentsExtending(this, ViewContainer.class)) {
            container.dispose();
        }
    }
}

