/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.protege.editor.core.ui.wizard.Wizard;
import org.protege.editor.core.ui.wizard.WizardModel;
import org.protege.editor.core.ui.wizard.WizardPanel;

public class WizardController
implements ActionListener {
    private Wizard wizard;

    public WizardController(Wizard w) {
        this.wizard = w;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("CancelButtonActionCommand")) {
            this.cancelButtonPressed();
        } else if (evt.getActionCommand().equals("BackButtonActionCommand")) {
            this.backButtonPressed();
        } else if (evt.getActionCommand().equals("NextButtonActionCommand")) {
            this.nextButtonPressed();
        }
    }

    public void cancel() {
        this.cancelButtonPressed();
    }

    private void cancelButtonPressed() {
        this.wizard.close(1);
    }

    public void next() {
        this.nextButtonPressed();
    }

    private void nextButtonPressed() {
        WizardModel model = this.wizard.getModel();
        WizardPanel descriptor = model.getCurrentPanelDescriptor();
        Object nextPanelDescriptor = descriptor.getNextPanelDescriptor();
        if (nextPanelDescriptor instanceof WizardPanel.FinishIdentifier) {
            descriptor.aboutToHidePanel();
            this.wizard.close(0);
        } else {
            this.wizard.setCurrentPanel(nextPanelDescriptor);
        }
    }

    private void backButtonPressed() {
        WizardModel model = this.wizard.getModel();
        WizardPanel descriptor = model.getCurrentPanelDescriptor();
        Object backPanelDescriptor = descriptor.getBackPanelDescriptor();
        this.wizard.setCurrentPanel(backPanelDescriptor);
    }

    public void resetButtonsToPanelRules() {
        WizardModel model = this.wizard.getModel();
        WizardPanel descriptor = model.getCurrentPanelDescriptor();
        model.setCancelButtonText(Wizard.CANCEL_TEXT);
        model.setBackButtonText(Wizard.BACK_TEXT);
        if (descriptor.getBackPanelDescriptor() != null) {
            model.setBackButtonEnabled(Boolean.TRUE);
        } else {
            model.setBackButtonEnabled(Boolean.FALSE);
        }
        if (descriptor.getNextPanelDescriptor() != null) {
            model.setNextFinishButtonEnabled(Boolean.TRUE);
        } else {
            model.setNextFinishButtonEnabled(Boolean.FALSE);
        }
        if (descriptor.getNextPanelDescriptor() instanceof WizardPanel.FinishIdentifier) {
            model.setNextFinishButtonText(Wizard.FINISH_TEXT);
        } else {
            model.setNextFinishButtonText(Wizard.NEXT_TEXT);
        }
    }
}

