/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;

public class WorkspaceManager {
    private static final Logger logger = Logger.getLogger(WorkspaceManager.class);
    private Map<Workspace, WorkspaceFrame> workspaceFrameMap = new HashMap<Workspace, WorkspaceFrame>();

    public void addWorkspace(final Workspace workspace) {
        if (!this.workspaceFrameMap.containsKey(workspace)) {
            final WorkspaceFrame frame = new WorkspaceFrame(workspace);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    if (WorkspaceManager.this.doClose(workspace)) {
                        frame.removeWindowListener(this);
                        frame.dispose();
                    }
                }
            });
            this.workspaceFrameMap.put(workspace, frame);
            frame.setDefaultCloseOperation(0);
            frame.setVisible(true);
        }
    }

    public boolean doClose(Workspace workspace) {
        boolean close = true;
        if (workspace.getEditorKit().getModelManager().isDirty()) {
            int ret = JOptionPane.showConfirmDialog(workspace, "Save modified ontologies?", "Unsaved ontologies", 1, 2);
            if (ret == 0) {
                try {
                    workspace.getEditorKit().handleSave();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    close = false;
                }
            } else if (ret != 1) {
                close = false;
            }
        }
        if (close) {
            ProtegeManager.getInstance().disposeOfEditorKit(workspace.getEditorKit());
        }
        return close;
    }

    public void removeWorkspace(Workspace workspace) {
        WorkspaceFrame frame = this.workspaceFrameMap.get(workspace);
        if (frame != null) {
            frame.dispose();
            this.workspaceFrameMap.remove(workspace);
        }
    }

    public WorkspaceFrame getFrame(Workspace workspace) {
        return this.workspaceFrameMap.get(workspace);
    }
}

