/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.workspace;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.util.Resettable;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewsPane;
import org.protege.editor.core.ui.view.ViewsPaneMemento;
import org.protege.editor.core.ui.workspace.WorkspaceTab;

public class WorkspaceViewsTab
extends WorkspaceTab
implements Resettable {
    private static final long serialVersionUID = 6574948332071917250L;
    public static final Logger logger = Logger.getLogger(WorkspaceViewsTab.class);
    private ViewsPane viewsPane;

    public ViewsPane getViewsPane() {
        return this.viewsPane;
    }

    public void initialise() {
        this.setLayout(new BorderLayout());
        ViewsPaneMemento memento = new ViewsPaneMemento(this);
        this.viewsPane = new ViewsPane(this.getWorkspace(), memento);
        this.add((Component)this.viewsPane, "Center");
        this.getWorkspace().getViewManager().registerViews(this);
    }

    public void reset() {
        for (View view : this.viewsPane.getViews()) {
            if (view.getViewComponent() == null || !(view.getViewComponent() instanceof Resettable)) continue;
            ((Resettable)((Object)view.getViewComponent())).reset();
        }
        this.getWorkspace().getViewManager().unregisterViews(this);
        this.remove(this.viewsPane);
        this.viewsPane.dispose();
        ViewsPaneMemento memento = new ViewsPaneMemento(this);
        memento.setForceReset(true);
        this.viewsPane = new ViewsPane(this.getWorkspace(), memento);
        this.add((Component)this.viewsPane, "Center");
        this.getWorkspace().getViewManager().registerViews(this);
    }

    public void reset(String serialisation) {
        this.getWorkspace().getViewManager().unregisterViews(this);
        this.viewsPane.storeViewLayout(serialisation);
        this.viewsPane.dispose();
        this.remove(this.viewsPane);
        this.viewsPane = new ViewsPane(this.getWorkspace(), new ViewsPaneMemento(this));
        this.add((Component)this.viewsPane, "Center");
        this.getWorkspace().getViewManager().registerViews(this);
        this.validate();
    }

    protected void setTopComponent(JComponent component) {
        this.add((Component)component, "North");
    }

    protected void setLeftComponent(JComponent component) {
        this.add((Component)component, "West");
    }

    protected void setRightComponent(JComponent component) {
        this.add((Component)component, "East");
    }

    protected void setBottomComponent(JComponent component) {
        this.add((Component)component, "South");
    }

    public void bringViewToFront(String viewId) {
        this.viewsPane.bringViewToFront(viewId);
    }

    public void save() {
        super.save();
        this.viewsPane.saveViews();
    }

    public void dispose() {
        this.viewsPane.saveViews();
        logger.debug((Object)"Disposing of views");
        this.viewsPane.dispose();
    }
}

