/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.core.ui.util.LinkLabel;
import org.protege.editor.core.ui.util.NativeBrowserLauncher;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.update.PluginManager;
import org.protege.editor.core.update.PluginRegistry;
import org.protege.editor.core.update.PluginTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginPanel
extends JPanel {
    private static final long serialVersionUID = 4791943048258319472L;
    private JLabel authorLabel;
    private JLabel licenseLabel;
    private JEditorPane readmePane;
    private JScrollPane readmeScroller;
    private Map<PluginInfo, ContentMimePair> updateInfoReadmeMap = new HashMap<PluginInfo, ContentMimePair>();
    private Set<PluginTable> tables = new HashSet<PluginTable>();
    private JCheckBox alwaysShow;

    public PluginPanel(Map<String, PluginRegistry> downloadsProviders) {
        this.setLayout(new BorderLayout(2, 2));
        JSplitPane sp = new JSplitPane(0);
        sp.setBorder(new EmptyBorder(6, 6, 6, 6));
        sp.setResizeWeight(0.5);
        final JTabbedPane tabbedPane = new JTabbedPane();
        for (String label : downloadsProviders.keySet()) {
            final PluginTable table = new PluginTable(downloadsProviders.get(label));
            this.tables.add(table);
            tabbedPane.addTab(label, table);
            table.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    PluginInfo info = table.getCurrentUpdateInfo();
                    PluginPanel.this.updateInfoPanel(info);
                }
            });
        }
        tabbedPane.setSelectedIndex(0);
        sp.setLeftComponent(tabbedPane);
        sp.setRightComponent(this.createInfoBox());
        this.add((Component)sp, "Center");
        tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                PluginTable table = (PluginTable)tabbedPane.getSelectedComponent();
                PluginPanel.this.updateInfoPanel(table.getCurrentUpdateInfo());
            }
        });
        this.alwaysShow = new JCheckBox("Always check for updates on startup.", PluginManager.getInstance().isAutoUpdateEnabled());
        this.alwaysShow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PluginManager.getInstance().setAutoUpdateEnabled(PluginPanel.this.alwaysShow.isSelected());
            }
        });
        this.alwaysShow.setAlignmentX(0.0f);
        this.add((Component)this.alwaysShow, "South");
    }

    private Component createInfoBox() {
        Box infoBox = new Box(3);
        infoBox.setBorder(ComponentFactory.createTitledBorder("Plugin info"));
        infoBox.add(Box.createRigidArea(new Dimension(0, 10)));
        infoBox.add(this.createAuthorPanel());
        infoBox.add(Box.createRigidArea(new Dimension(0, 10)));
        infoBox.add(this.createLicensePanel());
        infoBox.add(Box.createRigidArea(new Dimension(0, 20)));
        infoBox.add(this.createDocPanel());
        return infoBox;
    }

    private Component createAuthorPanel() {
        Box box = new Box(2);
        JLabel label = new JLabel("Author: ");
        Font font = label.getFont().deriveFont(8);
        label.setFont(font);
        label.setAlignmentX(0.0f);
        box.add(label);
        this.authorLabel = new JLabel("");
        this.authorLabel.setFont(font);
        box.add(this.authorLabel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private Component createLicensePanel() {
        Box box = new Box(2);
        JLabel label = new JLabel("License: ");
        Font font = label.getFont().deriveFont(8);
        label.setFont(font);
        label.setAlignmentX(0.0f);
        box.add(label);
        this.licenseLabel = new LinkLabel("", new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    URL url = new URL(PluginPanel.this.licenseLabel.getText());
                    NativeBrowserLauncher.openURL(url.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
        this.licenseLabel.setFont(font);
        box.add(this.licenseLabel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private Component createDocPanel() {
        this.readmePane = this.createTextPanel();
        this.readmeScroller = new JScrollPane(this.readmePane, 20, 31);
        this.readmeScroller.setOpaque(false);
        return this.readmeScroller;
    }

    private JEditorPane createTextPanel() {
        JEditorPane pane = new JEditorPane();
        pane.setBorder(new EmptyBorder(12, 12, 12, 12));
        pane.setPreferredSize(new Dimension(300, 200));
        pane.setEditable(false);
        pane.setFont(new Font("SansSerif", 0, 9));
        pane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getURL() != null) {
                    NativeBrowserLauncher.openURL(event.getURL().toString());
                }
            }
        });
        return pane;
    }

    private void updateInfoPanel(final PluginInfo info) {
        this.updateDocPanel(new ContentMimePair("", ""), this.readmePane, this.readmeScroller);
        if (info != null) {
            this.authorLabel.setText(info.getAuthor());
            this.licenseLabel.setText(info.getLicense());
            ContentMimePair readme = this.updateInfoReadmeMap.get(info);
            if (readme != null) {
                this.updateDocPanel(readme, this.readmePane, this.readmeScroller);
            } else {
                Runnable loadContent = new Runnable(){

                    public void run() {
                        final ContentMimePair readme = PluginPanel.this.getContent(info.getReadmeURI());
                        PluginPanel.this.updateInfoReadmeMap.put(info, readme);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                PluginPanel.this.updateDocPanel(readme, PluginPanel.this.readmePane, PluginPanel.this.readmeScroller);
                            }
                        });
                    }
                };
                Thread t = new Thread(loadContent, "Load plugin info");
                t.setPriority(1);
                t.start();
            }
        } else {
            this.authorLabel.setText("");
            this.licenseLabel.setText("");
        }
    }

    private ContentMimePair getContent(URL url) {
        if (url == null) {
            return new ContentMimePair("No info provided", "text/plain");
        }
        try {
            String line;
            String mimeType = url.openConnection().getContentType();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(url.openStream())));
            StringBuilder readmeBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                readmeBuilder.append(line);
                readmeBuilder.append("\n");
            }
            if (readmeBuilder.toString().contains("<html")) {
                mimeType = "text/html";
            }
            reader.close();
            return new ContentMimePair(readmeBuilder.toString(), mimeType);
        }
        catch (IOException e) {
            return new ContentMimePair("Problem obtaining details: " + e.getMessage(), "text/plain");
        }
    }

    private void updateDocPanel(ContentMimePair content, JEditorPane textEditor, final JScrollPane scroller) {
        textEditor.setContentType(content.mimeType);
        textEditor.setText(content.content);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                scroller.getViewport().setViewPosition(new Point(0, 0));
            }
        });
    }

    public List<PluginInfo> getPluginsToInstall() {
        ArrayList<PluginInfo> plugins = new ArrayList<PluginInfo>();
        for (PluginTable table : this.tables) {
            plugins.addAll(table.getSelectedUpdateInfo());
        }
        return plugins;
    }

    public static List<PluginInfo> showDialog(Map<String, PluginRegistry> downloadsProviders, Component parent) {
        PluginPanel panel = new PluginPanel(downloadsProviders);
        Object[] options = new String[]{"Install", "Not now"};
        int ret = JOptionPaneEx.showConfirmDialog(parent, "Automatic Update", panel, -1, 2, null, options, options[0]);
        if (ret == 0) {
            return panel.getPluginsToInstall();
        }
        return null;
    }

    class ContentMimePair {
        public String content;
        public String mimeType;

        ContentMimePair(String content, String mimeType) {
            this.content = content;
            this.mimeType = mimeType;
        }
    }
}

