/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.protege.editor.core.ui.preferences.PreferencesPanel;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.update.PluginManager;

public class PluginPreferencesPanel
extends PreferencesPanel {
    private static final long serialVersionUID = 3990983369055447871L;
    private JCheckBox checkForUpdatesAtStartupCheckBox;
    private JTextField pluginRegistryEditor;

    public void applyChanges() {
        PluginManager.getInstance().setAutoUpdateEnabled(this.checkForUpdatesAtStartupCheckBox.isSelected());
        try {
            URL url = new URL(this.pluginRegistryEditor.getText());
            PluginManager.getInstance().setPluginRegistryLocation(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose() throws Exception {
    }

    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        Box settingsHolder = new Box(3);
        settingsHolder.add(this.createAutoUpdatePanel());
        settingsHolder.add(Box.createVerticalStrut(12));
        settingsHolder.add(this.createRegistryPanel());
        this.add((Component)settingsHolder, "North");
    }

    private Component createAutoUpdatePanel() {
        Box box = new Box(1);
        box.setAlignmentX(0.0f);
        box.setBorder(ComponentFactory.createTitledBorder("Auto update"));
        this.checkForUpdatesAtStartupCheckBox = new JCheckBox("Automatically check for plugin updates at start up", PluginManager.getInstance().isAutoUpdateEnabled());
        this.checkForUpdatesAtStartupCheckBox.setAlignmentX(0.0f);
        JButton checkForUpdatesNow = new JButton(new AbstractAction("Check for updates now"){
            private static final long serialVersionUID = -1489049180196552810L;

            public void actionPerformed(ActionEvent e) {
                PluginManager.getInstance().checkForUpdates();
            }
        });
        checkForUpdatesNow.setAlignmentX(0.0f);
        box.add(this.checkForUpdatesAtStartupCheckBox);
        box.add(Box.createVerticalStrut(12));
        box.add(checkForUpdatesNow);
        return box;
    }

    private Component createRegistryPanel() {
        Box registryHolder = new Box(3);
        registryHolder.setAlignmentX(0.0f);
        registryHolder.setBorder(ComponentFactory.createTitledBorder("Plugin registry"));
        this.pluginRegistryEditor = new JTextField(PluginManager.getInstance().getPluginRegistryLocation().toString());
        this.pluginRegistryEditor.setColumns(30);
        JButton resetToDefaultRegistry = new JButton(new AbstractAction("Reset to default"){
            private static final long serialVersionUID = 2060172556249616568L;

            public void actionPerformed(ActionEvent event) {
                PluginPreferencesPanel.this.pluginRegistryEditor.setText("http://smi-protege.stanford.edu/protege4/plugins/4.1-plugins-2011-03-28.repository");
            }
        });
        JButton checkForDownloadsNow = new JButton(new AbstractAction("Check for downloads now"){
            private static final long serialVersionUID = 6345676228776716764L;

            public void actionPerformed(ActionEvent event) {
                PluginManager.getInstance().checkForDownloads();
            }
        });
        checkForDownloadsNow.setAlignmentX(0.0f);
        Box registryLocHolder = new Box(2);
        registryLocHolder.setAlignmentX(0.0f);
        registryLocHolder.add(this.pluginRegistryEditor);
        registryLocHolder.add(resetToDefaultRegistry);
        registryHolder.add(Box.createVerticalStrut(12));
        registryHolder.add(new JLabel("This is the location P4 will check to see which plugins are available."));
        registryHolder.add(Box.createVerticalStrut(12));
        registryHolder.add(registryLocHolder);
        registryHolder.add(Box.createVerticalStrut(12));
        registryHolder.add(checkForDownloadsNow);
        return registryHolder;
    }
}

