/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl;

import java.io.File;
import java.net.ProtocolException;
import java.net.URI;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.protege.editor.core.BookMarkedURIManager;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.editorkit.AbstractEditorKit;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitDescriptor;
import org.protege.editor.core.editorkit.EditorKitFactory;
import org.protege.editor.core.editorkit.RecentEditorKitManager;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.owl.OWLEditorKitFactory;
import org.protege.editor.owl.ProtegeOWL;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLModelManagerImpl;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.model.SaveErrorHandler;
import org.protege.editor.owl.model.io.IOListenerPlugin;
import org.protege.editor.owl.model.io.IOListenerPluginInstance;
import org.protege.editor.owl.model.io.IOListenerPluginLoader;
import org.protege.editor.owl.ui.OntologyFormatPanel;
import org.protege.editor.owl.ui.SaveConfirmationPanel;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.error.OntologyLoadErrorHandlerUI;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.ontology.imports.missing.MissingImportHandlerUI;
import org.protege.editor.owl.ui.ontology.wizard.create.CreateOntologyWizard;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLOntologyStorerNotFoundException;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEditorKit
extends AbstractEditorKit<OWLEditorKitFactory> {
    private static final Logger logger = Logger.getLogger(OWLEditorKit.class);
    public static final String ID = "OWLEditorKit";
    public static final String URI_KEY = "URI";
    private OWLWorkspace workspace;
    private OWLModelManager modelManager;
    private Set<URI> newPhysicalURIs;
    private OntologyLoadErrorHandlerUI loadErrorHandler;
    private ServiceRegistration registration;

    public OWLEditorKit(OWLEditorKitFactory editorKitFactory) {
        super((EditorKitFactory)editorKitFactory);
    }

    protected void initialise() {
        logger.info((Object)("Using OWL API version " + VersionInfo.getVersionInfo().getVersion()));
        this.newPhysicalURIs = new HashSet<URI>();
        this.modelManager = new OWLModelManagerImpl();
        this.modelManager.setExplanationManager(new ExplanationManager(this));
        this.modelManager.setMissingImportHandler(new MissingImportHandlerUI(this));
        this.modelManager.setSaveErrorHandler(new SaveErrorHandler(){

            public void handleErrorSavingOntology(OWLOntology ont, URI physicalURIForOntology, OWLOntologyStorageException e) throws Exception {
                OWLEditorKit.this.handleSaveError(ont, physicalURIForOntology, e);
            }
        });
        this.loadErrorHandler = new OntologyLoadErrorHandlerUI(this);
        this.modelManager.setLoadErrorHandler(this.loadErrorHandler);
        this.loadIOListenerPlugins();
        this.registration = ProtegeOWL.getBundleContext().registerService(EditorKit.class.getCanonicalName(), (Object)this, (Dictionary)new Properties());
    }

    @Deprecated
    public void setOWLModelManager(OWLModelManager modelManager) {
        this.modelManager = modelManager;
        ServiceReference sr = ProtegeOWL.getBundleContext().getServiceReference(PackageAdmin.class.getCanonicalName());
        PackageAdmin admin = (PackageAdmin)ProtegeOWL.getBundleContext().getService(sr);
        Bundle customizer = admin.getBundle(modelManager.getClass());
        String name = (String)customizer.getHeaders().get("Bundle-Name");
        if (name == null) {
            name = customizer.getSymbolicName();
        }
        this.getOWLWorkspace().setCustomizedBy("Prot\u00e9g\u00e9 Customized by " + name);
    }

    public String getId() {
        return ID;
    }

    public OWLWorkspace getWorkspace() {
        if (this.workspace == null) {
            this.workspace = new OWLWorkspace();
            this.workspace.setup((EditorKit)this);
            this.workspace.initialise();
        }
        return this.workspace;
    }

    public OWLWorkspace getOWLWorkspace() {
        return this.getWorkspace();
    }

    public OWLModelManager getModelManager() {
        return this.modelManager;
    }

    public OWLModelManager getOWLModelManager() {
        return this.getModelManager();
    }

    public boolean handleLoadRecentRequest(EditorKitDescriptor descriptor) throws Exception {
        URI uri = descriptor.getURI(URI_KEY);
        return uri != null && this.handleLoadFrom(uri);
    }

    public boolean handleLoadRequest() throws Exception {
        File f = new UIHelper(this).chooseOWLFile("Select an OWL file");
        return f != null && this.handleLoadFrom(f.toURI());
    }

    public boolean handleLoadFrom(URI uri) throws Exception {
        this.loadErrorHandler.setReloadFlag(false);
        boolean success = ((OWLModelManagerImpl)this.getModelManager()).loadOntologyFromPhysicalURI(uri);
        if (success) {
            this.addRecent(uri);
        } else if (this.loadErrorHandler.getReloadFlag()) {
            success = this.handleLoadFrom(uri);
        }
        return success;
    }

    public boolean handleNewRequest() throws Exception {
        OWLOntologyID id;
        CreateOntologyWizard w = new CreateOntologyWizard(null, this);
        int result = w.showModalDialog();
        if (result == 0 && (id = w.getOntologyID()) != null) {
            OWLOntology ont = this.getModelManager().createNewOntology(id, w.getLocationURI());
            this.getModelManager().getOWLOntologyManager().setOntologyFormat(ont, w.getFormat());
            this.newPhysicalURIs.add(w.getLocationURI());
            this.addRecent(w.getLocationURI());
            return true;
        }
        return false;
    }

    public void handleSave() throws Exception {
        try {
            Set<OWLOntology> dirtyOntologies = this.getModelManager().getDirtyOntologies();
            this.getModelManager().save();
            this.getWorkspace().save();
            for (URI uri : this.newPhysicalURIs) {
                this.addRecent(uri);
            }
            this.newPhysicalURIs.clear();
            SaveConfirmationPanel.showDialog(this, dirtyOntologies);
        }
        catch (OWLOntologyStorerNotFoundException e) {
            OWLOntology ont = this.getModelManager().getActiveOntology();
            OWLOntologyFormat format = this.getModelManager().getOWLOntologyManager().getOntologyFormat(ont);
            String message = "Could not save ontology in the specified format (" + format + ").\n" + "Please select 'Save As' and choose another format.";
            logger.warn((Object)message);
            ErrorLogPanel.showErrorDialog((Throwable)new OWLOntologyStorageException(message, (Throwable)e));
        }
    }

    public void handleSaveAs() throws Exception {
        OWLOntology ont = this.getModelManager().getActiveOntology();
        if (this.handleSaveAs(ont)) {
            SaveConfirmationPanel.showDialog(this, Collections.singleton(ont));
        }
    }

    private boolean handleSaveAs(OWLOntology ont) throws Exception {
        File file;
        OWLOntologyManager man = this.getModelManager().getOWLOntologyManager();
        OWLOntologyFormat oldFormat = man.getOntologyFormat(ont);
        OWLOntologyFormat format = OntologyFormatPanel.showDialog(this, oldFormat, "Choose a format to use when saving the " + this.getModelManager().getRendering((OWLObject)ont) + " ontology");
        if (format == null) {
            logger.warn((Object)"Please select a valid format");
            return false;
        }
        if (oldFormat instanceof PrefixOWLOntologyFormat && format instanceof PrefixOWLOntologyFormat) {
            PrefixOWLOntologyFormat oldPrefixes = (PrefixOWLOntologyFormat)oldFormat;
            for (String name : oldPrefixes.getPrefixNames()) {
                ((PrefixOWLOntologyFormat)format).setPrefix(name, oldPrefixes.getPrefix(name));
            }
        }
        if ((file = this.getSaveAsOWLFile(ont)) != null) {
            man.setOntologyFormat(ont, format);
            man.setOntologyDocumentIRI(ont, IRI.create((File)file));
            this.getModelManager().save(ont);
            this.addRecent(file.toURI());
            return true;
        }
        logger.warn((Object)"No valid file specified for the save as operation - quitting");
        return false;
    }

    private File getSaveAsOWLFile(OWLOntology ont) {
        UIHelper helper = new UIHelper(this);
        File file = helper.saveOWLFile("Please select a location in which to save: " + this.getModelManager().getRendering((OWLObject)ont));
        if (file != null) {
            int extensionIndex = file.toString().lastIndexOf(46);
            if (extensionIndex == -1) {
                file = new File(file.toString() + ".owl");
            } else if (extensionIndex != file.toString().length() - 4) {
                file = new File(file.toString() + ".owl");
            }
        }
        return file;
    }

    public void addRecent(URI physicalURI) {
        String label = physicalURI.toString();
        if (physicalURI.getScheme() != null && physicalURI.getScheme().equals("file")) {
            label = new File(physicalURI).getPath();
        } else {
            BookMarkedURIManager.getInstance().add(physicalURI);
        }
        EditorKitDescriptor descriptor = new EditorKitDescriptor(label, this.getEditorKitFactory());
        descriptor.setURI(URI_KEY, physicalURI);
        RecentEditorKitManager.getInstance().add(descriptor);
    }

    private void handleSaveError(OWLOntology ont, URI physicalURIForOntology, OWLOntologyStorageException e) throws Exception {
        if (e.getCause() == null || !(e.getCause() instanceof ProtocolException)) {
            throw e;
        }
        this.handleSaveAs(ont);
    }

    private void loadIOListenerPlugins() {
        IOListenerPluginLoader loader = new IOListenerPluginLoader(this);
        for (IOListenerPlugin pl : loader.getPlugins()) {
            try {
                IOListenerPluginInstance instance = (IOListenerPluginInstance)pl.newInstance();
                this.getModelManager().addIOListener(instance);
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
    }

    public Disposable get(Object key) {
        return this.getOWLModelManager().get(key);
    }

    public void put(Object key, Disposable value) {
        this.getOWLModelManager().put(key, value);
    }

    public void dispose() {
        super.dispose();
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

