/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitDescriptor;
import org.protege.editor.core.editorkit.EditorKitFactory;
import org.protege.editor.owl.OWLEditorKit;

public class OWLEditorKitFactory
implements EditorKitFactory {
    public static final String ID = "org.protege.editor.owl.OWLEditorKitFactory";
    public static final List<String> OWL_EXTENSIONS = Arrays.asList(".owl", ".rdf", ".xml");

    public String getId() {
        return ID;
    }

    public EditorKit createEditorKit() throws Exception {
        return new OWLEditorKit(this);
    }

    public boolean canLoad(URI uri) {
        String s = uri.toString();
        for (String ext : OWL_EXTENSIONS) {
            if (!s.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidDescriptor(EditorKitDescriptor descriptor) {
        URI uri = descriptor.getURI("URI");
        if (uri == null || uri.getScheme() == null) {
            return false;
        }
        if (uri.getScheme().equals("file")) {
            File file = new File(uri);
            return file.exists();
        }
        return true;
    }
}

