/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.ShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLExpressionUserCache
implements Disposable {
    private Logger logger = Logger.getLogger(OWLExpressionUserCache.class);
    private static final String ID = OWLExpressionUserCache.class.getName();
    private Map<OWLClassExpression, String> renderingsCache = new HashMap<OWLClassExpression, String>();
    private List<String> cacheInternalForm = new ArrayList<String>();
    private List<String> cacheExternalForm = null;
    private OWLModelManager mngr;
    private OWLModelManagerListener modelManagerListener = new OWLModelManagerListener(){

        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.getType().equals((Object)EventType.ACTIVE_ONTOLOGY_CHANGED) || event.getType().equals((Object)EventType.ENTITY_RENDERER_CHANGED) || event.getType().equals((Object)EventType.ENTITY_RENDERING_CHANGED) || event.getType().equals((Object)EventType.ONTOLOGY_RELOADED)) {
                OWLExpressionUserCache.this.refresh();
            }
        }
    };
    private static final String OWLCLASS = "OWLClass";
    private static final String OWLOBJECTPROPERTY = "OWLObjectProperty";
    private static final String OWLDATAPROPERTY = "OWLDataProperty";
    private static final String OWLANNOTATIONPROPERTY = "OWLAnnotationProperty";
    private static final String OWLINDIVIDUAL = "OWLIndividual";
    private static final String OWLDATATYPE = "OWLDatatype";
    private static final String DELIMITER = "::";
    private static final String WHITESPACE = " \n\t{}()[]'";

    public static OWLExpressionUserCache getInstance(OWLModelManager mngr) {
        OWLExpressionUserCache instance = (OWLExpressionUserCache)mngr.get(ID);
        if (instance == null) {
            instance = new OWLExpressionUserCache(mngr);
            mngr.put(ID, instance);
        }
        return instance;
    }

    private OWLExpressionUserCache(OWLModelManager mngr) {
        this.mngr = mngr;
        mngr.addListener(this.modelManagerListener);
        this.load();
    }

    public void add(OWLClassExpression owlDescription, String rendering) {
        String internalRendering;
        if (!this.getRenderings().contains(rendering)) {
            this.getRenderings().add(0, rendering);
        }
        if (!this.cacheInternalForm.contains(internalRendering = this.toInternalForm(rendering))) {
            this.cacheInternalForm.add(0, internalRendering);
        }
        this.renderingsCache.put(owlDescription, internalRendering);
    }

    public List<String> getRenderings() {
        if (this.cacheExternalForm == null) {
            this.cacheExternalForm = new ArrayList<String>();
            for (String s : this.cacheInternalForm) {
                String externalForm = this.fromInternalForm(s);
                if (externalForm == null) continue;
                this.cacheExternalForm.add(externalForm);
            }
        }
        return this.cacheExternalForm;
    }

    public String getRendering(OWLClassExpression descr) {
        return this.fromInternalForm(this.renderingsCache.get(descr));
    }

    public void refresh() {
        this.cacheExternalForm = null;
    }

    public void dispose() {
        this.save();
        this.renderingsCache.clear();
        this.renderingsCache = null;
        this.cacheExternalForm = null;
        this.cacheInternalForm = null;
        this.mngr.removeListener(this.modelManagerListener);
        this.mngr = null;
    }

    private void save() {
    }

    private void load() {
    }

    private String getPrefsID() {
        String fragment = this.mngr.getRendering((OWLObject)this.mngr.getActiveOntology());
        return fragment + "-" + this.mngr.getActiveOntology().hashCode();
    }

    private String toInternalForm(String input) {
        if (input == null) {
            return null;
        }
        InternalFormEntityRenderer ren = new InternalFormEntityRenderer();
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(input, WHITESPACE, true);
        int endIndex = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("'")) {
                while (tokenizer.hasMoreTokens() && !token.endsWith("'")) {
                    token = token + tokenizer.nextToken();
                }
            }
            int startIndex = input.indexOf(token, endIndex);
            OWLEntity entity = this.mngr.getOWLEntityFinder().getOWLEntity(token);
            if (entity != null) {
                sb.append(ren.render(entity));
            } else {
                sb.append(token);
            }
            endIndex = startIndex + token.length();
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String fromInternalForm(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(input, WHITESPACE, true);
        int endIndex = 0;
        while (tokenizer.hasMoreTokens()) {
            OWLEntity entity;
            String token = tokenizer.nextToken();
            int startIndex = input.indexOf(token, endIndex);
            if (token.equals("'")) {
                while (tokenizer.hasMoreTokens() && !token.endsWith("'")) {
                    token = token + tokenizer.nextToken();
                }
            }
            if ((entity = this.parseOWLEntity(token)) != null) {
                if (!this.containsEntity(entity)) return null;
                sb.append(this.mngr.getRendering((OWLObject)entity));
            } else {
                sb.append(token);
            }
            endIndex = startIndex + token.length();
        }
        return sb.toString();
    }

    private boolean containsEntity(OWLEntity entity) {
        for (OWLOntology ont : this.mngr.getActiveOntologies()) {
            if (!ont.containsEntityInSignature(entity)) continue;
            return true;
        }
        return false;
    }

    private OWLEntity parseOWLEntity(String name) {
        String[] s = name.split(DELIMITER);
        if (s[0].equals(OWLCLASS)) {
            return this.mngr.getOWLDataFactory().getOWLClass(IRI.create((String)s[1]));
        }
        if (s[0].equals(OWLOBJECTPROPERTY)) {
            return this.mngr.getOWLDataFactory().getOWLObjectProperty(IRI.create((String)s[1]));
        }
        if (s[0].equals(OWLDATAPROPERTY)) {
            return this.mngr.getOWLDataFactory().getOWLDataProperty(IRI.create((String)s[1]));
        }
        if (s[0].equals(OWLANNOTATIONPROPERTY)) {
            return this.mngr.getOWLDataFactory().getOWLAnnotationProperty(IRI.create((String)s[1]));
        }
        if (s[0].equals(OWLINDIVIDUAL)) {
            return this.mngr.getOWLDataFactory().getOWLNamedIndividual(IRI.create((String)s[1]));
        }
        if (s[0].equals(OWLDATATYPE)) {
            return this.mngr.getOWLDataFactory().getOWLDatatype(IRI.create((String)s[1]));
        }
        return null;
    }

    class InternalFormEntityRenderer
    implements ShortFormProvider,
    OWLEntityVisitor {
        private String cf;

        InternalFormEntityRenderer() {
        }

        public String render(OWLEntity entity) {
            this.cf = null;
            entity.accept((OWLEntityVisitor)this);
            return this.cf;
        }

        public void visit(OWLClass entity) {
            this.cf = "OWLClass::" + entity.getIRI();
        }

        public void visit(OWLObjectProperty entity) {
            this.cf = "OWLObjectProperty::" + entity.getIRI();
        }

        public void visit(OWLDataProperty entity) {
            this.cf = "OWLDataProperty::" + entity.getIRI();
        }

        public void visit(OWLNamedIndividual entity) {
            this.cf = "OWLIndividual::" + entity.getIRI();
        }

        public void visit(OWLDatatype entity) {
            this.cf = "OWLDatatype::" + entity.getIRI();
        }

        public void visit(OWLAnnotationProperty entity) {
            this.cf = "OWLAnnotationProperty::" + entity.getIRI();
        }

        public String getShortForm(OWLEntity owlEntity) {
            return this.render(owlEntity);
        }

        public void dispose() {
        }
    }
}

