/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.cache;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.cache.OWLExpressionUserCache;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.renderer.OWLObjectRenderer;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;

public class OWLObjectRenderingCache
implements Disposable {
    Map<OWLObject, String> cache = new MyLRUMap<OWLObject, String>(50, 1.0f, 50);
    private OWLModelManagerListener l = new OWLModelManagerListener(){

        public void handleChange(OWLModelManagerChangeEvent event) {
            OWLObjectRenderingCache.this.clear();
        }
    };
    private OWLOntologyChangeListener l2 = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> owlOntologyChanges) throws OWLException {
            OWLObjectRenderingCache.this.clear();
        }
    };
    private OWLModelManager mngr;

    public OWLObjectRenderingCache(OWLModelManager owlModelManager) {
        this.mngr = owlModelManager;
        owlModelManager.addListener(this.l);
        owlModelManager.addOntologyChangeListener(this.l2);
    }

    public void clear() {
        this.cache.clear();
    }

    public String getRendering(OWLObject object, OWLObjectRenderer owlObjectRenderer) {
        String userRendering;
        String s = null;
        if (object instanceof OWLClassExpression && (userRendering = OWLExpressionUserCache.getInstance(this.mngr).getRendering((OWLClassExpression)object)) != null) {
            s = userRendering;
            this.cache.put(object, s);
        }
        if (s == null && (s = this.cache.get(object)) == null) {
            s = owlObjectRenderer.render(object);
            this.cache.put(object, s);
        }
        return s;
    }

    public void dispose() {
        this.clear();
        this.mngr.removeListener(this.l);
        this.mngr.removeOntologyChangeListener(this.l2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyLRUMap<K, V>
    extends LinkedHashMap<K, V> {
        private int maxCapacity;

        public MyLRUMap(int initialCapacity, float loadFactor, int maxCapacity) {
            super(initialCapacity, loadFactor, true);
            this.maxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() >= this.maxCapacity;
        }
    }
}

