/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.classexpression.anonymouscls;

import java.util.ArrayList;
import java.util.List;
import org.protege.editor.owl.model.classexpression.anonymouscls.AnonymousDefinedClassManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADCRewriter {
    private AnonymousDefinedClassManager adcManager;
    private OWLObjectDuplicator duplicator;

    public ADCRewriter(final AnonymousDefinedClassManager adcManager, OWLDataFactory df) {
        this.adcManager = adcManager;
        this.duplicator = new OWLObjectDuplicator(df){

            public void visit(OWLClass owlClass) {
                if (adcManager.isAnonymous(owlClass)) {
                    this.setLastObject(adcManager.getExpression(owlClass));
                } else {
                    this.setLastObject(owlClass);
                }
            }
        };
    }

    public List<OWLOntologyChange> rewriteChanges(List<? extends OWLOntologyChange> changes) {
        ArrayList<OWLOntologyChange> rewrittenChanges = new ArrayList<OWLOntologyChange>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            rewrittenChanges.add(this.rewriteChange(oWLOntologyChange));
        }
        return rewrittenChanges;
    }

    public OWLOntologyChange rewriteChange(OWLOntologyChange chg) {
        if (!chg.isAxiomChange()) {
            return chg;
        }
        boolean rewriteRequired = false;
        for (OWLEntity entity : chg.getAxiom().getSignature()) {
            if (!entity.isOWLClass() || !this.adcManager.isAnonymous(entity.asOWLClass())) continue;
            rewriteRequired = true;
            break;
        }
        if (rewriteRequired) {
            if (chg instanceof AddAxiom) {
                return new AddAxiom(chg.getOntology(), this.rewriteAxiom(chg.getAxiom()));
            }
            return new RemoveAxiom(chg.getOntology(), this.rewriteAxiom(chg.getAxiom()));
        }
        return chg;
    }

    private OWLAxiom rewriteAxiom(OWLAxiom axiom) {
        return (OWLAxiom)this.duplicator.duplicateObject((OWLObject)axiom);
    }
}

