/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.find;

import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class OWLEntityFinderPreferences {
    public static final String PREFERENCES_KEY = "org.protege.editor.owl.finder";
    public static final String USE_REGULAR_EXPRESSIONS_KEY = "USE_REGULAR_EXPRESSIONS";
    public static final String SEARCH_DELAY_KEY = "SEARCH_DELAY_KEY";
    private static OWLEntityFinderPreferences instance;
    private boolean useRegularExpressions = false;
    private long searchDelay = 500L;

    private OWLEntityFinderPreferences() {
        this.load();
    }

    private static Preferences getPreferences() {
        return PreferencesManager.getInstance().getApplicationPreferences(PREFERENCES_KEY);
    }

    private void load() {
        Preferences prefs = OWLEntityFinderPreferences.getPreferences();
        this.useRegularExpressions = prefs.getBoolean(USE_REGULAR_EXPRESSIONS_KEY, false);
        this.searchDelay = prefs.getLong(SEARCH_DELAY_KEY, 500L);
    }

    public boolean isUseRegularExpressions() {
        return this.useRegularExpressions;
    }

    public void setUseRegularExpressions(boolean useRegularExpressions) {
        this.useRegularExpressions = useRegularExpressions;
        OWLEntityFinderPreferences.getPreferences().putBoolean(USE_REGULAR_EXPRESSIONS_KEY, useRegularExpressions);
    }

    public long getSearchDelay() {
        return this.searchDelay;
    }

    public void setSearchDelay(long searchDelay) {
        this.searchDelay = searchDelay;
        OWLEntityFinderPreferences.getPreferences().putLong(SEARCH_DELAY_KEY, searchDelay);
    }

    public static synchronized OWLEntityFinderPreferences getInstance() {
        if (instance == null) {
            instance = new OWLEntityFinderPreferences();
        }
        return instance;
    }
}

