/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owlapi.util.OWLOntologyChangeVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndividualsByTypeHierarchyProvider
extends AbstractOWLObjectHierarchyProvider<OWLObject> {
    private Set<OWLNamedIndividual> untypedIndividuals = new HashSet<OWLNamedIndividual>();
    private Set<OWLClass> classes = new HashSet<OWLClass>();
    private Set<OWLOntology> ontologies = new HashSet<OWLOntology>();
    private OWLOntologyChangeListener ontChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            IndividualsByTypeHierarchyProvider.this.handleOntologyChanges(changes);
        }
    };

    public IndividualsByTypeHierarchyProvider(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
        owlOntologyManager.addOntologyChangeListener(this.ontChangeListener);
    }

    @Override
    public void setOntologies(Set<OWLOntology> ontologies) {
        this.ontologies.clear();
        this.ontologies.addAll(ontologies);
        this.rebuild();
    }

    private void rebuild() {
        this.classes.clear();
        this.untypedIndividuals.clear();
        HashSet<OWLNamedIndividual> typedIndividuals = new HashSet<OWLNamedIndividual>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLNamedIndividual ind : ont.getIndividualsInSignature()) {
                this.untypedIndividuals.add(ind);
                for (OWLClassAssertionAxiom ax : ont.getClassAssertionAxioms((OWLIndividual)ind)) {
                    if (ax.getClassExpression().isAnonymous()) continue;
                    this.classes.add(ax.getClassExpression().asOWLClass());
                    typedIndividuals.add(ind);
                }
            }
        }
        this.untypedIndividuals.removeAll(typedIndividuals);
        this.fireHierarchyChanged();
    }

    @Override
    public Set<OWLObject> getRoots() {
        HashSet<OWLClass> roots = new HashSet<OWLClass>(this.classes);
        roots.addAll(this.untypedIndividuals);
        return roots;
    }

    @Override
    public Set<OWLObject> getChildren(OWLObject object) {
        if (object instanceof OWLClass && this.classes.contains((OWLClass)object)) {
            OWLClass cls = (OWLClass)object;
            HashSet<OWLObject> individuals = new HashSet<OWLObject>();
            for (OWLOntology ont : this.ontologies) {
                for (OWLClassAssertionAxiom ax : ont.getClassAssertionAxioms((OWLClassExpression)cls)) {
                    if (ax.getIndividual().isAnonymous()) continue;
                    individuals.add((OWLObject)ax.getIndividual());
                }
            }
            return individuals;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<OWLObject> getParents(OWLObject object) {
        if (object instanceof OWLNamedIndividual) {
            OWLNamedIndividual ind = (OWLNamedIndividual)object;
            HashSet<OWLObject> clses = new HashSet<OWLObject>();
            for (OWLOntology ont : this.ontologies) {
                for (OWLClassAssertionAxiom ax : ont.getClassAssertionAxioms((OWLIndividual)ind)) {
                    if (ax.getClassExpression().isAnonymous()) continue;
                    clses.add((OWLObject)ax.getClassExpression().asOWLClass());
                }
            }
            return clses;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<OWLObject> getEquivalents(OWLObject object) {
        return Collections.emptySet();
    }

    @Override
    public boolean containsReference(OWLObject object) {
        return object instanceof OWLNamedIndividual || object instanceof OWLClass && this.classes.contains((OWLClass)object);
    }

    @Override
    public void dispose() {
        this.getManager().removeOntologyChangeListener(this.ontChangeListener);
        super.dispose();
    }

    public Set<OWLClass> getRootClasses() {
        return new HashSet<OWLClass>(this.classes);
    }

    public Set<OWLNamedIndividual> getUntypedIndividuals() {
        return new HashSet<OWLNamedIndividual>(this.untypedIndividuals);
    }

    private void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
        TypesChangeVisitor changeVisitor = new TypesChangeVisitor();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            oWLOntologyChange.accept((OWLOntologyChangeVisitor)changeVisitor);
        }
        for (OWLObject oWLObject : changeVisitor.getNodes()) {
            this.fireNodeChanged(oWLObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TypesChangeVisitor
    extends OWLOntologyChangeVisitorAdapter {
        private Set<OWLObject> changedNodes = new HashSet<OWLObject>();
        Set<OWLNamedIndividual> checkIndividuals = new HashSet<OWLNamedIndividual>();
        private OWLAxiomVisitor addAxiomVisitor = new OWLAxiomVisitorAdapter(){

            public void visit(OWLClassAssertionAxiom ax) {
                TypesChangeVisitor.this.handleAddClassAssertionAxiom(ax);
            }
        };
        private OWLAxiomVisitor removeAxiomVisitor = new OWLAxiomVisitorAdapter(){

            public void visit(OWLClassAssertionAxiom ax) {
                TypesChangeVisitor.this.handleRemoveClassAssertionAxiom(ax);
            }
        };

        TypesChangeVisitor() {
        }

        public Set<OWLObject> getNodes() {
            for (OWLNamedIndividual ind : this.checkIndividuals) {
                if (IndividualsByTypeHierarchyProvider.this.untypedIndividuals.contains(ind)) {
                    if (!this.isTyped(ind) && this.isReferenced(ind)) continue;
                    IndividualsByTypeHierarchyProvider.this.untypedIndividuals.remove(ind);
                    this.changedNodes.add((OWLObject)ind);
                    continue;
                }
                if (!this.isReferenced(ind) || this.isTyped(ind)) continue;
                IndividualsByTypeHierarchyProvider.this.untypedIndividuals.add(ind);
                this.changedNodes.add((OWLObject)ind);
            }
            this.checkIndividuals.clear();
            return this.changedNodes;
        }

        public void visit(AddAxiom addAxiom) {
            if (IndividualsByTypeHierarchyProvider.this.ontologies.contains(addAxiom.getOntology())) {
                this.handleAxiomChange((OWLAxiomChange)addAxiom);
                addAxiom.getAxiom().accept(this.addAxiomVisitor);
            }
        }

        public void visit(RemoveAxiom removeAxiom) {
            if (IndividualsByTypeHierarchyProvider.this.ontologies.contains(removeAxiom.getOntology())) {
                this.handleAxiomChange((OWLAxiomChange)removeAxiom);
                removeAxiom.getAxiom().accept(this.removeAxiomVisitor);
            }
        }

        private void handleAxiomChange(OWLAxiomChange chg) {
            for (OWLEntity ref : chg.getAxiom().getSignature()) {
                if (!ref.isOWLNamedIndividual()) continue;
                this.checkIndividuals.add(ref.asOWLNamedIndividual());
            }
        }

        private void handleAddClassAssertionAxiom(OWLClassAssertionAxiom ax) {
            if (!ax.getClassExpression().isAnonymous()) {
                OWLClass type = ax.getClassExpression().asOWLClass();
                if (IndividualsByTypeHierarchyProvider.this.classes.contains(type)) {
                    this.changedNodes.add((OWLObject)type);
                } else {
                    IndividualsByTypeHierarchyProvider.this.classes.add(type);
                    this.changedNodes.add((OWLObject)type);
                }
            }
        }

        private void handleRemoveClassAssertionAxiom(OWLClassAssertionAxiom ax) {
            if (!ax.getClassExpression().isAnonymous()) {
                OWLClass type = ax.getClassExpression().asOWLClass();
                if (IndividualsByTypeHierarchyProvider.this.classes.contains(type)) {
                    if (IndividualsByTypeHierarchyProvider.this.getChildren((OWLObject)type).isEmpty()) {
                        IndividualsByTypeHierarchyProvider.this.classes.remove(type);
                    }
                    this.changedNodes.add((OWLObject)type);
                }
            }
        }

        private boolean isTyped(OWLNamedIndividual ind) {
            for (OWLOntology ont : IndividualsByTypeHierarchyProvider.this.ontologies) {
                if (ont.getClassAssertionAxioms((OWLIndividual)ind).isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean isReferenced(OWLNamedIndividual ind) {
            for (OWLOntology ont : IndividualsByTypeHierarchyProvider.this.ontologies) {
                if (!ont.containsIndividualInSignature(ind.getIRI())) continue;
                return true;
            }
            return false;
        }
    }
}

