/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLAnnotationPropertyHierarchyProvider
extends AbstractOWLObjectHierarchyProvider<OWLAnnotationProperty> {
    private Set<OWLOntology> ontologies;
    private Set<OWLAnnotationProperty> roots;
    private OWLOntologyChangeListener ontologyListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
            OWLAnnotationPropertyHierarchyProvider.this.handleChanges(changes);
        }
    };

    public OWLAnnotationPropertyHierarchyProvider(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
        this.roots = new HashSet<OWLAnnotationProperty>();
        this.ontologies = new HashSet<OWLOntology>();
        owlOntologyManager.addOntologyChangeListener(this.ontologyListener);
    }

    @Override
    public Set<OWLAnnotationProperty> getRoots() {
        return Collections.unmodifiableSet(this.roots);
    }

    @Override
    public final void setOntologies(Set<OWLOntology> ontologies) {
        this.ontologies.clear();
        this.ontologies.addAll(ontologies);
        this.rebuildRoots();
        this.fireHierarchyChanged();
    }

    @Override
    public boolean containsReference(OWLAnnotationProperty object) {
        for (OWLOntology ont : this.ontologies) {
            if (!ont.getAnnotationPropertiesInSignature().contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLAnnotationProperty> getChildren(OWLAnnotationProperty object) {
        HashSet<OWLAnnotationProperty> result = new HashSet<OWLAnnotationProperty>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLSubAnnotationPropertyOfAxiom ax : ont.getAxioms(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
                OWLAnnotationProperty subProp;
                if (!ax.getSuperProperty().equals(object) || this.getAncestors(subProp = ax.getSubProperty()).contains(subProp)) continue;
                result.add(subProp);
            }
        }
        return result;
    }

    @Override
    public Set<OWLAnnotationProperty> getEquivalents(OWLAnnotationProperty object) {
        HashSet<OWLAnnotationProperty> result = new HashSet<OWLAnnotationProperty>();
        Set<OWLAnnotationProperty> ancestors = this.getAncestors(object);
        if (ancestors.contains(object)) {
            for (OWLAnnotationProperty anc : ancestors) {
                if (!this.getAncestors(anc).contains(object)) continue;
                result.add(anc);
            }
        }
        result.remove(object);
        return result;
    }

    @Override
    public Set<OWLAnnotationProperty> getParents(OWLAnnotationProperty object) {
        HashSet<OWLAnnotationProperty> result = new HashSet<OWLAnnotationProperty>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLSubAnnotationPropertyOfAxiom ax : ont.getSubAnnotationPropertyOfAxioms(object)) {
                if (!ax.getSubProperty().equals(object)) continue;
                OWLAnnotationProperty superProp = ax.getSuperProperty();
                result.add(superProp);
            }
        }
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getManager().removeOntologyChangeListener(this.ontologyListener);
    }

    private void handleChanges(List<? extends OWLOntologyChange> changes) {
        HashSet<OWLAnnotationProperty> properties = new HashSet<OWLAnnotationProperty>(this.getPropertiesReferencedInChange(changes));
        for (OWLAnnotationProperty prop : properties) {
            if (this.isRoot(prop)) {
                this.roots.add(prop);
            } else if (this.getAncestors(prop).contains(prop)) {
                this.roots.add(prop);
                for (OWLAnnotationProperty anc : this.getAncestors(prop)) {
                    if (!this.getAncestors(anc).contains(prop)) continue;
                    this.roots.add(anc);
                    this.fireNodeChanged(anc);
                }
            } else {
                this.roots.remove(prop);
            }
            this.fireNodeChanged(prop);
        }
    }

    private Set<OWLAnnotationProperty> getPropertiesReferencedInChange(List<? extends OWLOntologyChange> changes) {
        final HashSet<OWLAnnotationProperty> props = new HashSet<OWLAnnotationProperty>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange()) continue;
            oWLOntologyChange.getAxiom().accept((OWLAxiomVisitor)new OWLAxiomVisitorAdapter(){

                public void visit(OWLSubAnnotationPropertyOfAxiom owlSubAnnotationPropertyOfAxiom) {
                    props.add(owlSubAnnotationPropertyOfAxiom.getSubProperty());
                    props.add(owlSubAnnotationPropertyOfAxiom.getSuperProperty());
                }

                public void visit(OWLDeclarationAxiom owlDeclarationAxiom) {
                    if (owlDeclarationAxiom.getEntity().isOWLAnnotationProperty()) {
                        props.add(owlDeclarationAxiom.getEntity().asOWLAnnotationProperty());
                    }
                }
            });
        }
        return props;
    }

    private boolean isRoot(OWLAnnotationProperty prop) {
        boolean isRoot = this.getParents(prop).isEmpty();
        if (isRoot && this.containsReference(prop)) {
            return true;
        }
        return this.getAncestors(prop).contains(prop);
    }

    private void rebuildRoots() {
        this.roots.clear();
        OWLDataFactory df = this.getManager().getOWLDataFactory();
        HashSet annotationProperties = new HashSet();
        for (OWLOntology ont : this.ontologies) {
            annotationProperties.addAll(ont.getAnnotationPropertiesInSignature());
        }
        for (OWLAnnotationProperty prop : annotationProperties) {
            if (!this.isRoot(prop)) continue;
            this.roots.add(prop);
        }
        for (IRI uri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS) {
            this.roots.add(df.getOWLAnnotationProperty(uri));
        }
    }
}

