/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.semanticweb.owlapi.model.OWLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectHierarchyDiffTool<N extends OWLObject> {
    private OWLObjectHierarchyProvider<N> fromProv;
    private OWLObjectHierarchyProvider<N> toProv;

    public OWLObjectHierarchyDiffTool(OWLObjectHierarchyProvider<N> fromProv, OWLObjectHierarchyProvider<N> toProv) {
        this.fromProv = fromProv;
        this.toProv = toProv;
    }

    public Set<N> getAddedParents(N child) {
        HashSet<N> parents = new HashSet<N>(this.toProv.getParents(child));
        parents.removeAll(new HashSet<N>(this.fromProv.getParents(child)));
        return parents;
    }

    public boolean isChanged(N child) {
        return !this.getAddedParents(child).isEmpty() || !this.getRemovedParents(child).isEmpty();
    }

    public Set<N> getRemovedParents(N child) {
        HashSet<N> parents = new HashSet<N>(this.fromProv.getParents(child));
        parents.removeAll(new HashSet<N>(this.toProv.getParents(child)));
        return parents;
    }
}

