/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.tabbed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.owl.model.entity.OWLEntityCreationException;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.entity.OWLEntityFactory;
import org.protege.editor.owl.model.hierarchy.tabbed.Edge;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLClassHierarchyCreator {
    private OWLDataFactory df;
    private OWLEntityFactory entityFactory;
    private OWLClass root;
    private List<Edge> edges;
    private OWLOntology ont;
    private boolean siblingsDisjoint;
    private Map<String, OWLClass> nameMap = new HashMap<String, OWLClass>();
    private List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
    private Map<OWLClass, Set<OWLClass>> parent2ChildMap = new HashMap<OWLClass, Set<OWLClass>>();

    public OWLClassHierarchyCreator(OWLDataFactory df, OWLEntityFactory fac, OWLClass rootClass, boolean makeSiblingClassesDisjoint, OWLOntology ontology, List<Edge> edges) {
        this.df = df;
        this.entityFactory = fac;
        this.root = rootClass;
        this.edges = edges;
        this.ont = ontology;
        this.siblingsDisjoint = makeSiblingClassesDisjoint;
    }

    public List<OWLOntologyChange> createHierarchy() {
        this.changes.clear();
        for (Edge edge : this.edges) {
            this.handleEdge(edge);
        }
        if (this.siblingsDisjoint) {
            this.handleDisjoints();
        }
        return this.changes;
    }

    private void handleDisjoints() {
        for (Set<OWLClass> clses : this.parent2ChildMap.values()) {
            if (clses.size() <= 1) continue;
            this.changes.add((OWLOntologyChange)new AddAxiom(this.ont, (OWLAxiom)this.df.getOWLDisjointClassesAxiom(clses)));
        }
    }

    private void handleEdge(Edge edge) {
        OWLClass child = this.getOWLClass(edge.getChild());
        OWLClass parent = this.root;
        if (!edge.isRoot()) {
            parent = this.getOWLClass(edge.getParent());
        }
        if (this.siblingsDisjoint) {
            this.addToMap(parent, child);
        }
        this.changes.add((OWLOntologyChange)new AddAxiom(this.ont, (OWLAxiom)this.df.getOWLSubClassOfAxiom((OWLClassExpression)child, (OWLClassExpression)parent)));
    }

    protected OWLClass getOWLClass(String name) {
        OWLClass cls = this.nameMap.get(name);
        if (cls == null) {
            try {
                OWLEntityCreationSet<OWLClass> creationSet = this.entityFactory.createOWLClass(name, null);
                this.changes.addAll(creationSet.getOntologyChanges());
                cls = creationSet.getOWLEntity();
                this.nameMap.put(name, cls);
            }
            catch (OWLEntityCreationException e) {
                ErrorLogPanel.showErrorDialog((Throwable)((Object)e));
            }
        }
        return cls;
    }

    private void addToMap(OWLClass parent, OWLClass child) {
        Set<OWLClass> children = this.parent2ChildMap.get(parent);
        if (children == null) {
            children = new HashSet<OWLClass>();
            this.parent2ChildMap.put(parent, children);
        }
        children.add(child);
    }
}

