/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.tabbed;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.protege.editor.owl.model.hierarchy.tabbed.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabIndentedHierarchyParser {
    private List<Line> lineList;
    private String prefix;
    private String suffix;
    private int tabSize;

    public TabIndentedHierarchyParser(int indent) {
        this(indent, null, null);
    }

    public TabIndentedHierarchyParser(int indent, String prefix, String suffix) {
        this.tabSize = indent;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public List<Edge> parse(Reader reader) throws IOException {
        this.lineList = new ArrayList<Line>();
        BufferedReader r = new BufferedReader(reader);
        this.createLines(r);
        return this.getEdges();
    }

    private void createLines(BufferedReader reader) throws IOException {
        String line;
        String tabString = "";
        for (int i = 0; i < this.tabSize; ++i) {
            tabString = tabString + " ";
        }
        while ((line = reader.readLine()) != null) {
            String normalisedLine = line.replaceAll("\t", tabString);
            String trimmedLine = normalisedLine.trim();
            if (this.prefix != null) {
                trimmedLine = this.prefix + trimmedLine;
            }
            if (this.suffix != null) {
                trimmedLine = trimmedLine + this.suffix;
            }
            if (trimmedLine.length() <= 0) continue;
            this.lineList.add(new Line(this.getIndent(normalisedLine), trimmedLine));
        }
    }

    private List<Edge> getEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (int i = 0; i < this.lineList.size(); ++i) {
            Line curLine = this.lineList.get(i);
            Edge e = null;
            for (int j = i - 1; j > -1; --j) {
                Line candidateLine = this.lineList.get(j);
                if (candidateLine.getIndent() >= curLine.getIndent()) continue;
                e = new Edge(curLine.getLine(), candidateLine.getLine());
                break;
            }
            if (e == null) {
                e = new Edge(curLine.getLine(), null);
            }
            edges.add(e);
        }
        return edges;
    }

    private int getIndent(String line) {
        int count = 0;
        for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
            ++count;
        }
        return count / this.tabSize;
    }

    private class Line {
        private int indent;
        private String line;

        public Line(int indent, String line) {
            this.indent = indent;
            this.line = line;
        }

        public int getIndent() {
            return this.indent;
        }

        public String getLine() {
            return this.line;
        }
    }
}

