/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.history;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JList;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.history.HistoryManager;
import org.protege.editor.owl.model.history.ReverseChangeGenerator;
import org.protege.editor.owl.model.history.UndoManagerListener;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryManagerImpl
implements HistoryManager {
    private static Logger logger = Logger.getLogger(HistoryManager.class);
    private OWLModelManager owlModelManager;
    private boolean inUndoMode;
    private Stack<List<OWLOntologyChange>> undoStack;
    private Stack<List<OWLOntologyChange>> redoStack;
    private List<UndoManagerListener> listeners;
    JList viewList;

    public HistoryManagerImpl(OWLModelManager owlModelManager) {
        this.owlModelManager = owlModelManager;
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.listeners = new ArrayList<UndoManagerListener>();
        this.inUndoMode = false;
    }

    @Override
    public boolean canRedo() {
        return this.redoStack.size() > 0;
    }

    @Override
    public boolean canUndo() {
        return this.undoStack.size() > 0;
    }

    @Override
    public void logChanges(List<? extends OWLOntologyChange> changes) {
        if (!this.inUndoMode) {
            this.redoStack.clear();
            this.undoStack.push(new ArrayList<OWLOntologyChange>(changes));
        } else {
            ArrayList<OWLOntologyChange> redoChanges = new ArrayList<OWLOntologyChange>();
            for (OWLOntologyChange oWLOntologyChange : changes) {
                ReverseChangeGenerator gen = new ReverseChangeGenerator();
                oWLOntologyChange.accept((OWLOntologyChangeVisitor)gen);
                redoChanges.add(0, gen.getReverseChange());
            }
            this.redoStack.push(new ArrayList(redoChanges));
        }
        this.fireStateChanged();
    }

    @Override
    public void redo() {
        if (this.canRedo()) {
            try {
                List<OWLOntologyChange> redoChanges = this.redoStack.pop();
                this.owlModelManager.applyChanges(redoChanges);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() {
        if (this.canUndo()) {
            try {
                this.inUndoMode = true;
                List<OWLOntologyChange> changes = this.undoStack.pop();
                ArrayList<OWLOntologyChange> undoChanges = new ArrayList<OWLOntologyChange>();
                for (OWLOntologyChange change : changes) {
                    ReverseChangeGenerator gen = new ReverseChangeGenerator();
                    change.accept((OWLOntologyChangeVisitor)gen);
                    undoChanges.add(0, gen.getReverseChange());
                }
                this.owlModelManager.applyChanges(undoChanges);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                this.inUndoMode = false;
            }
        }
    }

    @Override
    public void addUndoManagerListener(UndoManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeUndoManagerListener(UndoManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public List<List<OWLOntologyChange>> getLoggedChanges() {
        ArrayList<List<OWLOntologyChange>> copyOfLog = new ArrayList<List<OWLOntologyChange>>();
        for (List list : this.undoStack) {
            copyOfLog.add(new ArrayList(list));
        }
        return copyOfLog;
    }

    public void fireStateChanged() {
        for (UndoManagerListener listener : new ArrayList<UndoManagerListener>(this.listeners)) {
            listener.stateChanged(this);
        }
    }
}

