/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.library.folder;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.model.library.CatalogEntryManager;
import org.protege.editor.owl.model.library.LibraryUtilities;
import org.protege.editor.owl.model.library.folder.Algorithm;
import org.protege.editor.owl.model.library.folder.XmlBaseAlgorithm;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.library.NewEntryPanel;
import org.protege.editor.owl.ui.library.plugins.FolderGroupPanel;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.Prefer;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.XmlBaseContext;
import org.protege.xmlcatalog.entry.Entry;
import org.protege.xmlcatalog.entry.GroupEntry;
import org.protege.xmlcatalog.entry.UriEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderGroupManager
extends CatalogEntryManager {
    private static final Logger logger = Logger.getLogger(FolderGroupManager.class);
    public static final int FOLDER_BY_URI_VERSION = 1;
    public static final int CURRENT_VERSION = 2;
    public static final String ID_PREFIX = "Folder Repository";
    public static final String DIR_PROP = "directory";
    public static final String RECURSIVE_PROP = "recursive";
    public static final String FILE_KEY = "FILE";
    private Set<Algorithm> algorithms;
    private boolean autoUpdate = true;
    private boolean warnedUserOfBadRepositoryDeclaration = false;
    private GroupEntry ge;
    private File folder;
    private boolean recursive = true;
    private long timeOfCurrentUpdate;
    private boolean modified = false;
    private Map<File, Collection<URI>> retainedFileToWebLocationMap = new TreeMap<File, Collection<URI>>();
    private Map<URI, Collection<URI>> webLocationToFileLocationMap = new TreeMap<URI, Collection<URI>>();

    public static GroupEntry createGroupEntry(URI folder, boolean recursive, boolean autoUpdate, XmlBaseContext context) throws IOException {
        return new GroupEntry(FolderGroupManager.getIdString(folder, recursive, autoUpdate), context, Prefer.PUBLIC, folder);
    }

    public FolderGroupManager() {
        this.algorithms = new HashSet<Algorithm>();
        this.algorithms.add(new XmlBaseAlgorithm());
    }

    public void setAlgorithms(Algorithm ... algorithms) {
        this.algorithms.clear();
        for (Algorithm algorithm : algorithms) {
            this.algorithms.add(algorithm);
        }
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public boolean isSuitable(Entry entry) {
        boolean hasRightType;
        if (!(entry instanceof GroupEntry)) {
            return false;
        }
        GroupEntry ge = (GroupEntry)entry;
        File dir = this.getDirectory(ge);
        boolean enabled = LibraryUtilities.getBooleanProperty((Entry)ge, "Auto-Update", false);
        boolean bl = hasRightType = ge.getId() != null && ge.getId().startsWith(ID_PREFIX) && enabled && dir != null;
        if (!(!hasRightType || dir.exists() && dir.isDirectory())) {
            logger.warn((Object)"Folder repository probably came from another system");
            logger.warn((Object)("Could not be updated because directory " + dir + " does not exist"));
            if (!this.warnedUserOfBadRepositoryDeclaration) {
                ProtegeApplication.getErrorLog().logError((Throwable)new IOException("Bad ontology library declaration - check logs. Warnings now disabled for this session."));
                this.warnedUserOfBadRepositoryDeclaration = true;
            }
            return false;
        }
        return hasRightType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(Entry entry) {
        this.ge = (GroupEntry)entry;
        this.reset();
        this.ensureLatestVersion();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"********************************* Starting Catalog Update ************************************************");
                logger.debug((Object)("Update of group entry " + this.ge.getId() + " started at " + new Date(this.timeOfCurrentUpdate)));
            }
            this.retainEntries();
            this.examineDiskEntries(this.folder, new HashSet<URI>());
            if (this.modified) {
                this.clearEntries();
                this.writeEntries();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"********************************* Catalog Update Complete ************************************************");
            }
            boolean bl = this.modified;
            return bl;
        }
        finally {
            this.ge = null;
            this.reset();
        }
    }

    @Override
    public boolean initializeCatalog(File folder, XMLCatalog catalog) throws IOException {
        URI relativeFolderUri = CatalogUtilities.relativize((URI)folder.toURI(), (XmlBaseContext)catalog);
        this.ge = FolderGroupManager.createGroupEntry(relativeFolderUri, true, this.autoUpdate, (XmlBaseContext)catalog);
        catalog.addEntry((Entry)this.ge);
        this.update((Entry)this.ge);
        return true;
    }

    @Override
    public NewEntryPanel newEntryPanel(XMLCatalog catalog) {
        return new FolderGroupPanel(catalog);
    }

    @Override
    public String getDescription() {
        return ID_PREFIX;
    }

    @Override
    public String getDescription(Entry ge) {
        StringBuffer sb = new StringBuffer("<html><body><b>Folder Repository for ");
        sb.append(this.getDirectory((GroupEntry)ge));
        sb.append("</b>");
        if (LibraryUtilities.getBooleanProperty(ge, RECURSIVE_PROP, true)) {
            sb.append(" <font color=\"gray\">(Recursive)</font>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    private static String getIdString(URI folderUri, boolean recursive, boolean autoUpdate) {
        StringBuffer sb = new StringBuffer(ID_PREFIX);
        LibraryUtilities.addPropertyValue(sb, DIR_PROP, folderUri.toString());
        LibraryUtilities.addPropertyValue(sb, RECURSIVE_PROP, recursive);
        LibraryUtilities.addPropertyValue(sb, "Auto-Update", autoUpdate ? "true" : "false");
        LibraryUtilities.addPropertyValue(sb, "version", 2);
        return sb.toString();
    }

    private void reset() {
        this.modified = false;
        this.timeOfCurrentUpdate = System.currentTimeMillis();
        this.retainedFileToWebLocationMap.clear();
        this.webLocationToFileLocationMap.clear();
        if (this.ge != null) {
            this.folder = this.getDirectory(this.ge);
            this.recursive = LibraryUtilities.getBooleanProperty((Entry)this.ge, RECURSIVE_PROP, true);
        } else {
            this.folder = null;
        }
    }

    private void ensureLatestVersion() {
        int version = LibraryUtilities.getVersion((Entry)this.ge);
        if (version < 2) {
            boolean autoUpdate = LibraryUtilities.getBooleanProperty((Entry)this.ge, "Auto-Update", this.autoUpdate);
            this.ge.setId(FolderGroupManager.getIdString(this.folder.toURI(), this.recursive, autoUpdate));
            this.clearEntries();
        }
    }

    private void retainEntries() {
        for (Entry e : new ArrayList(this.ge.getEntries())) {
            if (!(e instanceof UriEntry)) continue;
            UriEntry ue = (UriEntry)e;
            try {
                long lastUpdated = -1L;
                String updatedString = LibraryUtilities.getStringProperty((Entry)ue, "Timestamp");
                try {
                    if (updatedString != null) {
                        lastUpdated = Long.parseLong(updatedString);
                    }
                }
                catch (NumberFormatException nfe) {
                    logger.info((Object)("Could not parse timestamps in catalog file " + nfe));
                }
                File f = new File(ue.getAbsoluteURI());
                if (!f.exists() || f.lastModified() >= lastUpdated) {
                    this.modified = true;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Map for file " + f + " is stale and has been removed"));
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Map for file " + f + " is still good and will be kept"));
                }
                this.recordRetainedEntry(URI.create(ue.getName()), f.getCanonicalFile());
            }
            catch (Throwable t) {
                logger.info((Object)("Exception caught updating catalog entry " + t));
            }
        }
    }

    private void examineDiskEntries(File tree, Set<URI> webLocationsFoundInParentDirectory) {
        HashSet<URI> newWebLocations = new HashSet<URI>();
        if (this.algorithms == null || this.algorithms.isEmpty()) {
            return;
        }
        HashSet<File> subFolders = new HashSet<File>();
        for (File physicalLocation : tree.listFiles()) {
            if (this.recursive && physicalLocation.exists() && physicalLocation.isDirectory()) {
                subFolders.add(physicalLocation);
                continue;
            }
            if (!physicalLocation.exists() || !physicalLocation.isFile() || !this.isValidOWLFile(physicalLocation)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applying algorithms to " + physicalLocation));
            }
            URI shortLocation = this.folder.toURI().relativize(physicalLocation.toURI());
            Collection<URI> retainedSuggestions = null;
            try {
                retainedSuggestions = this.retainedFileToWebLocationMap.get(physicalLocation.getCanonicalFile());
            }
            catch (IOException e) {
                logger.warn((Object)("IO Exception caught processing file " + physicalLocation + " for repository library update"), (Throwable)e);
            }
            if (retainedSuggestions != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Adding mappings retained from previous version of the catalog");
                }
                this.recordEntries(retainedSuggestions, shortLocation, webLocationsFoundInParentDirectory, newWebLocations);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Adding new mappings not found in the previous version of the catalog");
            }
            for (Algorithm algorithm : this.algorithms) {
                Set<URI> webLocations = algorithm.getSuggestions(physicalLocation);
                this.modified = this.modified || !webLocations.isEmpty();
                this.recordEntries(webLocations, shortLocation, webLocationsFoundInParentDirectory, newWebLocations);
            }
        }
        webLocationsFoundInParentDirectory.addAll(newWebLocations);
        for (File physicalLocation : subFolders) {
            this.examineDiskEntries(physicalLocation, webLocationsFoundInParentDirectory);
        }
    }

    protected boolean isValidOWLFile(File physicalLocation) {
        if (physicalLocation.getName().startsWith(".")) {
            return false;
        }
        String path = physicalLocation.getPath();
        for (String extension : UIHelper.OWL_EXTENSIONS) {
            if (!path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private void recordEntries(Collection<URI> webLocations, URI physicalLocation, Set<URI> webLocationsFoundInParentDirectory, Set<URI> newWebLocations) {
        for (URI webLocation : webLocations) {
            if (!webLocationsFoundInParentDirectory.contains(webLocation)) {
                newWebLocations.add(webLocation);
                this.recordEntry(webLocation, physicalLocation);
                continue;
            }
            this.recordEntry(this.appendScheme(webLocation, "shadowed:"), physicalLocation);
        }
    }

    private void recordEntry(URI webLocation, URI physicalLocation) {
        Collection<URI> possibleFileLocations;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found mapping from import location " + webLocation + " to physical file " + physicalLocation));
        }
        if ((possibleFileLocations = this.webLocationToFileLocationMap.get(webLocation)) == null) {
            possibleFileLocations = new ArrayList<URI>();
            this.webLocationToFileLocationMap.put(webLocation, possibleFileLocations);
        }
        possibleFileLocations.add(physicalLocation);
    }

    private void recordRetainedEntry(URI webLocation, File f) {
        Collection<URI> possibleWebLocations = this.retainedFileToWebLocationMap.get(f);
        if (possibleWebLocations == null) {
            possibleWebLocations = new ArrayList<URI>();
            this.retainedFileToWebLocationMap.put(f, possibleWebLocations);
        }
        possibleWebLocations.add(this.removeIgnoredSchemes(webLocation));
    }

    private void clearEntries() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Catalog must be modified - clearing out existing data");
        }
        for (Entry e : this.ge.getEntries()) {
            this.ge.removeEntry(e);
        }
    }

    private void writeEntries() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Catalog must be modified - writing new data");
        }
        for (URI webLocation : this.webLocationToFileLocationMap.keySet()) {
            Collection<URI> physicalLocations = this.webLocationToFileLocationMap.get(webLocation);
            if (physicalLocations.size() > 1 && !this.isIgnored(webLocation)) {
                this.writeEntries(this.appendScheme(webLocation, "duplicate:"), physicalLocations);
                continue;
            }
            this.writeEntries(webLocation, physicalLocations);
        }
    }

    private void writeEntries(URI webLocation, Collection<URI> physicalLocations) {
        for (URI physicalLocation : physicalLocations) {
            String entryId = "Automatically generated entry, Timestamp=" + this.timeOfCurrentUpdate;
            UriEntry u = new UriEntry(entryId, (XmlBaseContext)this.ge, webLocation.toString(), physicalLocation, null);
            this.ge.addEntry((Entry)u);
            this.modified = true;
        }
    }

    private URI appendScheme(URI u, String scheme) {
        String uString = u.toString();
        return URI.create(scheme + uString);
    }

    private URI removeIgnoredSchemes(URI u) {
        String uString = u.toString();
        for (String iScheme : CatalogEntryManager.IGNORED_SCHEMES) {
            if (!uString.startsWith(iScheme)) continue;
            return URI.create(uString.substring(iScheme.length()));
        }
        return u;
    }

    private boolean isIgnored(URI u) {
        String uString = u.toString();
        for (String iScheme : CatalogEntryManager.IGNORED_SCHEMES) {
            if (!uString.startsWith(iScheme)) continue;
            return true;
        }
        return false;
    }

    private File getDirectory(GroupEntry ge) {
        File folder = null;
        String dirName = LibraryUtilities.getStringProperty((Entry)ge, DIR_PROP);
        if (dirName == null) {
            return null;
        }
        if (LibraryUtilities.getVersion((Entry)ge) < 1) {
            folder = new File(dirName);
        } else {
            URI dirURI = CatalogUtilities.resolveXmlBase((XmlBaseContext)ge).resolve(dirName);
            folder = new File(dirURI);
        }
        return folder;
    }
}

