/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.refactor.ontology;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.refactor.ontology.OWLEntityIRIRegenerator;
import org.protege.editor.owl.model.refactor.ontology.OntologyImportsWalker;
import org.protege.editor.owl.model.refactor.ontology.OntologyTargetResolver;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererImpl;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.AnnotationValueShortFormProvider;
import org.semanticweb.owlapi.util.OWLEntityURIConverter;
import org.semanticweb.owlapi.util.OWLEntityURIConverterStrategy;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertEntityURIsToIdentifierPattern {
    private Logger logger = Logger.getLogger(ConvertEntityURIsToIdentifierPattern.class);
    public Set<OWLOntology> ontologies;
    private OWLModelManager mngr;
    private Map<OWLEntity, IRI> iriMap = new HashMap<OWLEntity, IRI>();
    private OntologyImportsWalker ontologyImportsWalker;
    private OntologyTargetResolver resolver;

    public ConvertEntityURIsToIdentifierPattern(OWLModelManager mngr, Set<OWLOntology> ontologies) {
        this.ontologies = ontologies;
        this.mngr = mngr;
        this.ontologyImportsWalker = new OntologyImportsWalker(mngr, ontologies);
        this.setupRenderers();
    }

    public void setOntologyResolver(OntologyTargetResolver resolver) {
        this.resolver = resolver;
    }

    public void performConversion() {
        this.buildNewIRIMap();
        if (!this.iriMap.isEmpty()) {
            ArrayList<? extends OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
            changes.addAll(this.createNewLabelAxioms());
            OWLEntityURIConverterStrategy converterStrategy = new OWLEntityURIConverterStrategy(){

                public IRI getConvertedIRI(OWLEntity owlEntity) {
                    IRI uri = (IRI)ConvertEntityURIsToIdentifierPattern.this.iriMap.get(owlEntity);
                    return uri != null ? uri : owlEntity.getIRI();
                }
            };
            OWLEntityURIConverter entityURIConverter = new OWLEntityURIConverter(this.mngr.getOWLOntologyManager(), this.mngr.getOntologies(), converterStrategy);
            changes.addAll(entityURIConverter.getChanges());
            this.mngr.applyChanges(changes);
        }
        this.logger.info((Object)("Converted " + this.iriMap.size() + " entities to use labels"));
    }

    private void setupRenderers() {
    }

    private void buildNewIRIMap() {
        this.iriMap.clear();
        ShortFormProvider nullSFP = new ShortFormProvider(){

            public String getShortForm(OWLEntity owlEntity) {
                return null;
            }

            public void dispose() {
            }
        };
        ArrayList<OWLAnnotationProperty> annotationProperties = new ArrayList<OWLAnnotationProperty>();
        HashMap<OWLAnnotationProperty, List<String>> langMap = new HashMap<OWLAnnotationProperty, List<String>>();
        Map<IRI, List<String>> annotMap = OWLRendererPreferences.getInstance().getAnnotationLangMap();
        for (IRI iri : annotMap.keySet()) {
            OWLAnnotationProperty p = this.mngr.getOWLDataFactory().getOWLAnnotationProperty(iri);
            annotationProperties.add(p);
            langMap.put(p, annotMap.get(iri));
        }
        AnnotationValueShortFormProvider sfp = new AnnotationValueShortFormProvider(annotationProperties, langMap, (OWLOntologySetProvider)this.mngr.getOWLOntologyManager(), nullSFP);
        OWLEntityIRIRegenerator IRIGen = new OWLEntityIRIRegenerator(this.mngr);
        for (OWLEntity entity : this.getAllReferencedEntities()) {
            String labelRendering = sfp.getShortForm(entity);
            if (labelRendering != null && !this.refactorWhenLabelPresent(entity, labelRendering)) continue;
            this.iriMap.put(entity, IRIGen.generateNewIRI(entity));
        }
        try {
            IRIGen.dispose();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean refactorWhenLabelPresent(OWLEntity entity, String labelRendering) {
        String iri = entity.getIRI().toString();
        if (!iri.endsWith(labelRendering)) {
            return false;
        }
        char c = iri.charAt(iri.length() - 1 - labelRendering.length());
        return c == '#' || c == '/';
    }

    private Collection<? extends OWLOntologyChange> createNewLabelAxioms() {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        OWLDataFactory df = this.mngr.getOWLDataFactory();
        EntityOfSameTypeGenerator gen = new EntityOfSameTypeGenerator(df);
        OWLEntityRendererImpl fragmentRenderer = new OWLEntityRendererImpl();
        fragmentRenderer.setup(this.mngr);
        fragmentRenderer.initialise();
        for (OWLEntity entity : this.iriMap.keySet()) {
            Set<OWLOntology> onts = this.getOntologiesForEntityLabel(entity);
            if (!onts.isEmpty()) {
                String uriRendering = fragmentRenderer.render(entity);
                OWLAnnotation annotation = this.generateLabelAnnotation(uriRendering);
                IRI newIRI = this.iriMap.get(entity);
                OWLEntity newEntity = gen.getEntityOfSameType(newIRI, entity);
                OWLAnnotationAssertionAxiom ax = df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)newEntity.getIRI(), annotation);
                for (OWLOntology ont : onts) {
                    changes.add(new AddAxiom(ont, (OWLAxiom)ax));
                }
                continue;
            }
            this.logger.warn((Object)("Ignored ID conversion for entity (" + this.mngr.getRendering((OWLObject)entity) + "): cannot determine suitable ontology target for axiom"));
        }
        fragmentRenderer.dispose();
        return changes;
    }

    private OWLAnnotation generateLabelAnnotation(String label) {
        OWLDataFactory df = this.mngr.getOWLDataFactory();
        OWLAnnotationProperty aProp = this.getPreferredLabel();
        String lang = this.getPreferredLanguage();
        OWLLiteral value = df.getOWLLiteral(label, lang);
        return df.getOWLAnnotation(aProp, (OWLAnnotationValue)value);
    }

    private String getPreferredLanguage() {
        List<String> langs = OWLRendererPreferences.getInstance().getAnnotationLangs();
        return langs.isEmpty() ? null : langs.get(0);
    }

    private Set<OWLOntology> getOntologiesForEntityLabel(OWLEntity entity) {
        Set<OWLOntology> onts = this.ontologyImportsWalker.getLowestOntologiesToContainReference(entity);
        if (onts.size() == 1) {
            return onts;
        }
        if (this.resolver != null) {
            return this.resolver.resolve(entity, onts);
        }
        return Collections.emptySet();
    }

    public OWLAnnotationProperty getPreferredLabel() {
        List<IRI> iris = OWLRendererPreferences.getInstance().getAnnotationIRIs();
        IRI iri = iris.isEmpty() ? IRI.create((URI)OWLRDFVocabulary.RDFS_LABEL.getURI()) : iris.get(0);
        return this.mngr.getOWLDataFactory().getOWLAnnotationProperty(iri);
    }

    private Set<OWLEntity> getAllReferencedEntities() {
        HashSet<OWLEntity> entities = new HashSet<OWLEntity>();
        for (OWLOntology ont : this.ontologies) {
            entities.addAll(ont.getSignature());
        }
        entities.remove(this.mngr.getOWLDataFactory().getOWLThing());
        return entities;
    }

    public void dispose() {
        this.ontologyImportsWalker.dispose();
        this.iriMap.clear();
        this.ontologies.clear();
        this.mngr = null;
    }

    class EntityOfSameTypeGenerator
    implements OWLEntityVisitor {
        private OWLDataFactory df;
        private IRI iri;
        private OWLEntity entity;

        public EntityOfSameTypeGenerator(OWLDataFactory df) {
            this.df = df;
        }

        public OWLEntity getEntityOfSameType(IRI iri, OWLEntity entity) {
            this.iri = iri;
            entity.accept((OWLEntityVisitor)this);
            return this.entity;
        }

        public void visit(OWLClass owlClass) {
            this.entity = this.df.getOWLClass(this.iri);
        }

        public void visit(OWLObjectProperty owlObjectProperty) {
            this.entity = this.df.getOWLObjectProperty(this.iri);
        }

        public void visit(OWLDataProperty owlDataProperty) {
            this.entity = this.df.getOWLDataProperty(this.iri);
        }

        public void visit(OWLNamedIndividual owlNamedIndividual) {
            this.entity = this.df.getOWLNamedIndividual(this.iri);
        }

        public void visit(OWLDatatype owlDatatype) {
            this.entity = this.df.getOWLDatatype(this.iri);
        }

        public void visit(OWLAnnotationProperty owlAnnotationProperty) {
            this.entity = this.df.getOWLAnnotationProperty(this.iri);
        }
    }
}

