/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.refactor.ontology;

import org.protege.editor.core.Disposable;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.entity.CustomOWLEntityFactory;
import org.protege.editor.owl.model.entity.OWLEntityCreationException;
import org.protege.editor.owl.model.entity.OWLEntityFactory;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererImpl;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;

public class OWLEntityIRIRegenerator
implements Disposable {
    private OWLEntityFactory fac;
    private OWLEntityRendererImpl fragmentRenderer = new OWLEntityRendererImpl();

    public OWLEntityIRIRegenerator(OWLModelManager mngr) {
        this.fragmentRenderer.setup(mngr);
        this.fragmentRenderer.initialise();
        this.fac = new CustomOWLEntityFactory(mngr){

            protected boolean isFragmentAutoGenerated() {
                return true;
            }
        };
    }

    public IRI generateNewIRI(OWLEntity entity) {
        IRI base = this.getBaseIRI(entity);
        String id = "";
        OWLEntity newEntity = this.getEntity(entity, id, base);
        return newEntity.getIRI();
    }

    private OWLEntity getEntity(OWLEntity entity, String id, IRI base) {
        try {
            return this.fac.createOWLEntity(entity.getClass(), id, base).getOWLEntity();
        }
        catch (OWLEntityCreationException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    private IRI getBaseIRI(OWLEntity entity) {
        String fragment = this.fragmentRenderer.render(entity);
        IRI iri = entity.getIRI();
        if (fragment != null) {
            return IRI.create((String)iri.toString().substring(0, iri.toString().lastIndexOf(fragment)));
        }
        return iri;
    }

    public void dispose() throws Exception {
        this.fragmentRenderer.dispose();
    }
}

