/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.refactor.ontology;

import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.hierarchy.OWLOntologyHierarchyProvider;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyImportsWalker {
    private OWLOntologyHierarchyProvider hp;
    private Set<OWLOntology> ontologies;

    public OntologyImportsWalker(OWLModelManager mngr, Set<OWLOntology> ontologies) {
        this.hp = new OWLOntologyHierarchyProvider(mngr);
        this.ontologies = ontologies;
        this.hp.setOntologies(ontologies);
    }

    public Set<OWLOntology> getLowestOntologiesToContainReference(OWLEntity entity) {
        Set<OWLOntology> referencingOntologies = this.getReferencingOntologies(entity);
        return this.getLeaves(referencingOntologies);
    }

    private Set<OWLOntology> getReferencingOntologies(OWLEntity entity) {
        HashSet<OWLOntology> referencingOntologies = new HashSet<OWLOntology>();
        for (OWLOntology ont : this.ontologies) {
            if (!ont.containsEntityInSignature(entity)) continue;
            referencingOntologies.add(ont);
        }
        return referencingOntologies;
    }

    private Set<OWLOntology> getLeaves(Set<OWLOntology> onts) {
        HashSet<OWLOntology> leaves = new HashSet<OWLOntology>(onts);
        block0: for (OWLOntology ont : onts) {
            if (leaves.size() <= 1) break;
            Set<OWLOntology> ancestors = this.hp.getAncestors(ont);
            ancestors.remove(ont);
            for (OWLOntology ancestor : ancestors) {
                if (leaves.size() <= 1) continue block0;
                leaves.remove(ancestor);
            }
        }
        return leaves;
    }

    public void dispose() {
        this.hp.dispose();
    }
}

