/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.refactor.ontology;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyMerger {
    private static final Logger logger = Logger.getLogger(OntologyMerger.class);
    private OWLOntologyManager owlOntologyManager;
    private Set<OWLOntology> ontologies;
    private OWLOntology targetOntology;

    public OntologyMerger(OWLOntologyManager owlOntologyManager, Set<OWLOntology> ontologies, OWLOntology targetOntology) {
        this.ontologies = new HashSet<OWLOntology>(ontologies);
        this.owlOntologyManager = owlOntologyManager;
        this.targetOntology = targetOntology;
    }

    public void mergeOntologies() {
        ArrayList<Object> changes = new ArrayList<Object>();
        for (OWLOntology ont : this.ontologies) {
            if (ont.equals(this.targetOntology)) continue;
            for (OWLAxiom ax : ont.getAxioms()) {
                changes.add(new AddAxiom(this.targetOntology, ax));
            }
            for (OWLAnnotation annot : ont.getAnnotations()) {
                changes.add(new AddOntologyAnnotation(this.targetOntology, annot));
            }
            if (this.targetOntology.getOntologyID().isAnonymous()) continue;
            for (OWLImportsDeclaration decl : ont.getImportsDeclarations()) {
                if (this.ontologies.contains(ont.getOWLOntologyManager().getImportedOntology(decl))) continue;
                if (!decl.getIRI().equals(this.targetOntology.getOntologyID().getDefaultDocumentIRI())) {
                    changes.add(new AddImport(this.targetOntology, decl));
                    continue;
                }
                logger.warn((Object)("Merge: ignoring import declaration for ontology " + this.targetOntology.getOntologyID() + " (would result in target ontology importing itself)."));
            }
        }
        try {
            this.owlOntologyManager.applyChanges(changes);
        }
        catch (OWLOntologyChangeException e) {
            ErrorLogPanel.showErrorDialog((Throwable)e);
        }
    }
}

