/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.repository;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.protege.editor.core.OntologyRepository;
import org.protege.editor.core.OntologyRepositoryEntry;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterRepository
implements OntologyRepository {
    private String repositoryName;
    private URI repositoryLocation;
    private List<RepositoryEntry> entries;
    private OWLOntologyIRIMapper iriMapper;

    public ManchesterRepository(String repositoryName, URI repositoryLocation) {
        this.repositoryName = repositoryName;
        this.repositoryLocation = repositoryLocation;
        this.entries = new ArrayList<RepositoryEntry>();
        this.iriMapper = new RepositoryIRIMapper();
    }

    public void initialise() throws Exception {
    }

    public String getName() {
        return this.repositoryName;
    }

    public String getLocation() {
        return this.repositoryLocation.toString();
    }

    public void refresh() {
        this.fillRepository();
    }

    public Collection<OntologyRepositoryEntry> getEntries() {
        ArrayList<OntologyRepositoryEntry> ret = new ArrayList<OntologyRepositoryEntry>();
        ret.addAll(this.entries);
        return ret;
    }

    public List<Object> getMetaDataKeys() {
        return Collections.emptyList();
    }

    public void dispose() throws Exception {
    }

    private void fillRepository() {
        try {
            String line;
            this.entries.clear();
            URI listURI = URI.create(this.repositoryLocation + "/list");
            BufferedReader br = new BufferedReader(new InputStreamReader(listURI.toURL().openStream()));
            while ((line = br.readLine()) != null) {
                try {
                    this.entries.add(new RepositoryEntry(new URI(line)));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class RepositoryIRIMapper
    implements OWLOntologyIRIMapper {
        private RepositoryIRIMapper() {
        }

        public IRI getDocumentIRI(IRI iri) {
            for (RepositoryEntry entry : ManchesterRepository.this.entries) {
                if (!entry.getOntologyURI().equals(iri.toURI())) continue;
                return IRI.create((URI)entry.getPhysicalURI());
            }
            return null;
        }
    }

    private class RepositoryEntry
    implements OntologyRepositoryEntry {
        private String shortName;
        private URI ontologyURI;
        private URI physicalURI;

        public RepositoryEntry(URI ontologyIRI) {
            this.ontologyURI = ontologyIRI;
            OntologyIRIShortFormProvider sfp = new OntologyIRIShortFormProvider();
            this.shortName = sfp.getShortForm(IRI.create((URI)ontologyIRI));
            this.physicalURI = URI.create(ManchesterRepository.this.repositoryLocation + "/download?ontology=" + ontologyIRI);
        }

        public String getOntologyShortName() {
            return this.shortName;
        }

        public URI getOntologyURI() {
            return this.ontologyURI;
        }

        public URI getPhysicalURI() {
            return this.physicalURI;
        }

        public String getEditorKitId() {
            return "org.protege.editor.owl.OWLEditorKitFactory";
        }

        public String getMetaData(Object key) {
            return null;
        }

        public void configureEditorKit(EditorKit editorKit) {
            ((OWLEditorKit)editorKit).getOWLModelManager().getOWLOntologyManager().addIRIMapper(ManchesterRepository.this.iriMapper);
        }

        public void restoreEditorKit(EditorKit editorKit) {
            ((OWLEditorKit)editorKit).getOWLModelManager().getOWLOntologyManager().removeIRIMapper(ManchesterRepository.this.iriMapper);
        }
    }
}

