/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.repository;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.protege.editor.owl.model.repository.extractors.LastResortExtractor;
import org.protege.editor.owl.model.repository.extractors.OntologyIdExtractor;
import org.protege.editor.owl.model.repository.extractors.RdfXmlExtractor;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class MasterOntologyIDExtractor
implements OntologyIdExtractor {
    private List<OntologyIdExtractor> extractors = new ArrayList<OntologyIdExtractor>();

    public MasterOntologyIDExtractor() {
        this.extractors.add(new RdfXmlExtractor());
        this.extractors.add(new LastResortExtractor());
    }

    public MasterOntologyIDExtractor(URI location) {
        this();
        this.setPhysicalAddress(location);
    }

    public OWLOntologyID getOntologyId() {
        OntologyIdExtractor extractor;
        OWLOntologyID id = null;
        Iterator<OntologyIdExtractor> i$ = this.extractors.iterator();
        while (i$.hasNext() && (id = (extractor = i$.next()).getOntologyId()) == null) {
        }
        return id;
    }

    public void setPhysicalAddress(URI location) {
        for (OntologyIdExtractor extractor : this.extractors) {
            extractor.setPhysicalAddress(location);
        }
    }
}

