/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.selection;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.model.util.OWLAxiomInstance;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class OWLSelectionModelImpl
implements OWLSelectionModel {
    private static final Logger logger = Logger.getLogger(OWLSelectionModelImpl.class);
    private List<OWLSelectionModelListener> listeners;
    private OWLObject selectedObject;
    private OWLEntity lastSelectedEntity;
    private OWLClass lastSelectedClass;
    private OWLDataProperty lastSelectedDataProperty;
    private OWLObjectProperty lastSelectedObjectProperty;
    private OWLAnnotationProperty lastSelectedAnnotationProperty;
    private OWLNamedIndividual lastSelectedIndividual;
    private OWLDatatype lastSelectedDatatype;
    private OWLAxiomInstance lastSelectedAxiomInstance;
    private final OWLEntityVisitor updateVisitor = new OWLEntityVisitor(){

        public void visit(OWLClass cls) {
            OWLSelectionModelImpl.this.lastSelectedClass = cls;
        }

        public void visit(OWLObjectProperty property) {
            OWLSelectionModelImpl.this.lastSelectedObjectProperty = property;
        }

        public void visit(OWLDataProperty property) {
            OWLSelectionModelImpl.this.lastSelectedDataProperty = property;
        }

        public void visit(OWLAnnotationProperty owlAnnotationProperty) {
            OWLSelectionModelImpl.this.lastSelectedAnnotationProperty = owlAnnotationProperty;
        }

        public void visit(OWLNamedIndividual individual) {
            OWLSelectionModelImpl.this.lastSelectedIndividual = individual;
        }

        public void visit(OWLDatatype dataType) {
            OWLSelectionModelImpl.this.lastSelectedDatatype = dataType;
        }
    };
    private final OWLEntityVisitor clearVisitor = new OWLEntityVisitor(){

        public void visit(OWLClass cls) {
            if (OWLSelectionModelImpl.this.lastSelectedClass != null && OWLSelectionModelImpl.this.lastSelectedClass.equals(cls)) {
                OWLSelectionModelImpl.this.lastSelectedClass = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }

        public void visit(OWLObjectProperty property) {
            if (OWLSelectionModelImpl.this.lastSelectedObjectProperty != null && OWLSelectionModelImpl.this.lastSelectedObjectProperty.equals(property)) {
                OWLSelectionModelImpl.this.lastSelectedObjectProperty = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }

        public void visit(OWLDataProperty property) {
            if (OWLSelectionModelImpl.this.lastSelectedDataProperty != null && OWLSelectionModelImpl.this.lastSelectedDataProperty.equals(property)) {
                OWLSelectionModelImpl.this.lastSelectedDataProperty = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }

        public void visit(OWLAnnotationProperty property) {
            if (OWLSelectionModelImpl.this.lastSelectedAnnotationProperty != null && OWLSelectionModelImpl.this.lastSelectedAnnotationProperty.equals(property)) {
                OWLSelectionModelImpl.this.lastSelectedAnnotationProperty = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }

        public void visit(OWLNamedIndividual individual) {
            if (OWLSelectionModelImpl.this.lastSelectedIndividual != null && OWLSelectionModelImpl.this.lastSelectedIndividual.equals(individual)) {
                OWLSelectionModelImpl.this.lastSelectedIndividual = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }

        public void visit(OWLDatatype dataType) {
            if (OWLSelectionModelImpl.this.lastSelectedDatatype != null && OWLSelectionModelImpl.this.lastSelectedDatatype.equals(dataType)) {
                OWLSelectionModelImpl.this.lastSelectedDatatype = null;
                OWLSelectionModelImpl.this.fireSelectionChanged();
            }
        }
    };

    public OWLSelectionModelImpl() {
        this.listeners = new ArrayList<OWLSelectionModelListener>();
        logger.setLevel(Level.WARN);
    }

    public void addListener(OWLSelectionModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null!");
        }
        this.listeners.add(listener);
    }

    public void removeListener(OWLSelectionModelListener listener) {
        this.listeners.remove(listener);
    }

    public OWLObject getSelectedObject() {
        return this.selectedObject;
    }

    public void setSelectedObject(OWLObject object) {
        if (object == null) {
            if (this.selectedObject != null) {
                this.updateSelectedObject(null);
            }
        } else if (this.selectedObject == null) {
            this.updateSelectedObject(object);
        } else if (!this.selectedObject.equals(object)) {
            this.updateSelectedObject(object);
        }
    }

    private void updateSelectedObject(OWLObject selObj) {
        this.selectedObject = selObj;
        this.updateLastSelection();
        this.fireSelectionChanged();
    }

    public OWLEntity getSelectedEntity() {
        return this.lastSelectedEntity;
    }

    private void fireSelectionChanged() {
        for (OWLSelectionModelListener listener : new ArrayList<OWLSelectionModelListener>(this.listeners)) {
            try {
                listener.selectionChanged();
            }
            catch (Exception e) {
                logger.warn((Object)("BAD LISTENER: (" + listener.getClass().getSimpleName() + ") "));
                ProtegeApplication.getErrorLog().handleError(Thread.currentThread(), (Throwable)e);
            }
        }
    }

    public void setSelectedEntity(OWLEntity entity) {
        this.setSelectedObject((OWLObject)entity);
    }

    public void setSelectedAxiom(OWLAxiomInstance axiomInstance) {
        this.lastSelectedAxiomInstance = axiomInstance;
        this.setSelectedObject((OWLObject)axiomInstance.getAxiom());
    }

    public void clearLastSelectedEntity(OWLEntity entity) {
        if (entity == null) {
            return;
        }
        entity.accept(this.clearVisitor);
        if (this.lastSelectedEntity != null && entity.equals(this.lastSelectedEntity)) {
            this.lastSelectedEntity = null;
            this.fireSelectionChanged();
        }
    }

    private void updateLastSelection() {
        if (this.selectedObject == null) {
            return;
        }
        if (this.selectedObject instanceof OWLEntity) {
            this.lastSelectedEntity = (OWLEntity)this.selectedObject;
            this.lastSelectedEntity.accept(this.updateVisitor);
            this.lastSelectedAxiomInstance = null;
        }
    }

    public OWLClass getLastSelectedClass() {
        return this.lastSelectedClass;
    }

    public OWLObjectProperty getLastSelectedObjectProperty() {
        return this.lastSelectedObjectProperty;
    }

    public OWLDataProperty getLastSelectedDataProperty() {
        return this.lastSelectedDataProperty;
    }

    public OWLAnnotationProperty getLastSelectedAnnotationProperty() {
        return this.lastSelectedAnnotationProperty;
    }

    public OWLNamedIndividual getLastSelectedIndividual() {
        return this.lastSelectedIndividual;
    }

    public OWLDatatype getLastSelectedDatatype() {
        return this.lastSelectedDatatype;
    }

    public OWLAxiomInstance getLastSelectedAxiomInstance() {
        return this.lastSelectedAxiomInstance;
    }
}

