/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerManager<L> {
    private Map<L, StackTraceElement[]> listenerMap = new HashMap<L, StackTraceElement[]>();
    private static final int TRACE_DEPTH = 10;
    private static final int TRACE_START = 3;

    public void recordListenerAdded(L listener) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        this.listenerMap.put(listener, stackTrace);
    }

    public void recordListenerRemoved(L listener) {
        this.listenerMap.remove(listener);
    }

    public void dumpWarningForListener(L listener, Logger log, Level level, String cleanupMessage) {
        if (this.listenerMap.containsKey(listener)) {
            log.log((Priority)level, (Object)("*** WARNING BADLY BEHAVING LISTENER: " + listener.getClass().getName() + " ***"));
            StackTraceElement[] trace = this.listenerMap.get(listener);
            if (trace != null) {
                log.log((Priority)level, (Object)"    Possible culprit (trace from when listener was added): ");
                for (int i = 3; i < trace.length; ++i) {
                    String s = trace[i].toString();
                    if (i == 0) {
                        log.log((Priority)level, (Object)("        ->" + s));
                        continue;
                    }
                    log.log((Priority)level, (Object)("          " + s));
                }
            }
            log.log((Priority)level, (Object)("    " + cleanupMessage));
        }
    }

    public void dumpWarningForAllListeners(Logger log, Level level, String cleanupMessage) {
        for (L listener : this.listenerMap.keySet()) {
            this.dumpWarningForListener(listener, log, level, cleanupMessage);
        }
    }
}

