/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLDataTypeUtils {
    private OWLOntologyManager mngr;

    public OWLDataTypeUtils(OWLOntologyManager mngr) {
        this.mngr = mngr;
    }

    public Set<OWLDatatype> getBuiltinDatatypes() {
        HashSet<OWLDatatype> datatypes = new HashSet<OWLDatatype>();
        OWLDataFactory df = this.mngr.getOWLDataFactory();
        datatypes.add(df.getTopDatatype());
        for (OWL2Datatype dt : OWL2Datatype.values()) {
            datatypes.add(df.getOWLDatatype(dt.getIRI()));
        }
        return datatypes;
    }

    public Set<OWLDatatype> getReferencedDatatypes(Set<OWLOntology> onts) {
        HashSet<OWLDatatype> referencedTypes = new HashSet<OWLDatatype>();
        for (OWLOntology ont : onts) {
            referencedTypes.addAll(ont.getDatatypesInSignature());
        }
        return referencedTypes;
    }

    public Set<OWLDatatype> getKnownDatatypes(Set<OWLOntology> onts) {
        Set<OWLDatatype> knownTypes = this.getBuiltinDatatypes();
        for (OWLOntology ont : onts) {
            knownTypes.addAll(ont.getDatatypesInSignature());
        }
        return knownTypes;
    }
}

