/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.renderer.OWLOntologyCellRenderer;
import org.semanticweb.owlapi.io.OWLFunctionalSyntaxOntologyFormat;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatherOntologiesPanel
extends JPanel {
    private static final long serialVersionUID = 1595484840905361754L;
    private OWLEditorKit owlEditorKit;
    private OWLModelManager owlModelManager;
    private JComboBox formatComboBox;
    private File saveLocation;
    private Set<OWLOntology> ontologiesToSave;

    public GatherOntologiesPanel(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.owlModelManager = owlEditorKit.getModelManager();
        this.ontologiesToSave = new HashSet<OWLOntology>();
        this.createUI();
    }

    private void createUI() {
        JPanel holderPanel = new JPanel(new BorderLayout());
        JPanel comboBoxLabelPanel = new JPanel(new BorderLayout(7, 7));
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("Original");
        formats.add((String)new RDFXMLOntologyFormat());
        formats.add((String)new OWLXMLOntologyFormat());
        formats.add((String)new OWLFunctionalSyntaxOntologyFormat());
        this.formatComboBox = new JComboBox<Object>(formats.toArray());
        comboBoxLabelPanel.add((Component)new JLabel("Format"), "West");
        comboBoxLabelPanel.add((Component)this.formatComboBox, "East");
        JPanel formatPanelHolder = new JPanel();
        formatPanelHolder.add(comboBoxLabelPanel);
        holderPanel.add((Component)formatPanelHolder, "North");
        Box box = new Box(1);
        ArrayList<OWLOntology> orderedOntologies = new ArrayList<OWLOntology>(this.owlModelManager.getOntologies());
        Collections.sort(orderedOntologies, this.owlModelManager.getOWLObjectComparator());
        for (final OWLOntology ont : orderedOntologies) {
            this.ontologiesToSave.add(ont);
            String label = OWLOntologyCellRenderer.getOntologyLabelText(ont, this.owlModelManager);
            JCheckBox cb = new JCheckBox(new AbstractAction(label){
                private static final long serialVersionUID = 2401533090682630308L;

                public void actionPerformed(ActionEvent e) {
                    if (!GatherOntologiesPanel.this.ontologiesToSave.contains(ont)) {
                        GatherOntologiesPanel.this.ontologiesToSave.remove(ont);
                    } else {
                        GatherOntologiesPanel.this.ontologiesToSave.add(ont);
                    }
                }
            });
            cb.setSelected(true);
            cb.setOpaque(false);
            box.add(cb);
            box.add(Box.createVerticalStrut(3));
        }
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 150));
        box.setBackground(Color.WHITE);
        JPanel boxHolder = new JPanel(new BorderLayout());
        boxHolder.setBorder(ComponentFactory.createTitledBorder((String)"Ontologies"));
        boxHolder.add(new JScrollPane(box));
        boxHolder.setPreferredSize(new Dimension(boxHolder.getPreferredSize().width, Math.min(boxHolder.getPreferredSize().height, 300)));
        holderPanel.add((Component)boxHolder, "Center");
        holderPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)holderPanel, "Center");
    }

    public Set<OWLOntology> getOntologiesToSave() {
        return this.ontologiesToSave;
    }

    public OWLOntologyFormat getOntologyFormat() {
        Object selFormat = this.formatComboBox.getSelectedItem();
        if (selFormat instanceof OWLOntologyFormat) {
            return (OWLOntologyFormat)selFormat;
        }
        return null;
    }

    public File getSaveLocation() {
        return this.saveLocation;
    }

    public void setSaveLocation(File saveLocation) {
        this.saveLocation = saveLocation;
    }

    public static GatherOntologiesPanel showDialog(OWLEditorKit owlEditorKit) {
        GatherOntologiesPanel panel = new GatherOntologiesPanel(owlEditorKit);
        panel.setPreferredSize(new Dimension(600, 400));
        int ret = JOptionPane.showConfirmDialog(null, panel, "Gather ontologies", 2, -1);
        if (ret != 0) {
            return null;
        }
        File file = UIUtil.chooseFolder((Component)((Object)owlEditorKit.getWorkspace()), (String)"Select folder to save the ontologies to");
        if (file == null) {
            return null;
        }
        panel.setSaveLocation(file);
        return panel;
    }
}

